@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceProductPolicy].
 */
@PulumiTagMarker
public class WorkspaceProductPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceProductPolicyArgs = WorkspaceProductPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceProductPolicyArgsBuilder.() -> Unit) {
        val builder = WorkspaceProductPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceProductPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceProductPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceProductPolicy(builtJavaResource)
    }
}

/**
 * Policy Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceProductPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceProductPolicy = new AzureNative.ApiManagement.WorkspaceProductPolicy("workspaceProductPolicy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Xml,
 *         PolicyId = "policy",
 *         ProductId = "5702e97e5157a50f48dce801",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = @"<policies>
 *   <inbound>
 *     <rate-limit calls=""{{call-count}}"" renewal-period=""15""></rate-limit>
 *     <log-to-eventhub logger-id=""16"">
 *                       @( string.Join("","", DateTime.UtcNow, context.Deployment.ServiceName, context.RequestId, context.Request.IpAddress, context.Operation.Name) )
 *                   </log-to-eventhub>
 *     <quota-by-key calls=""40"" counter-key=""cc"" renewal-period=""3600"" increment-count=""@(context.Request.Method == &quot;POST&quot; ? 1:2)"" />
 *     <base />
 *   </inbound>
 *   <backend>
 *     <base />
 *   </backend>
 *   <outbound>
 *     <base />
 *   </outbound>
 * </policies>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceProductPolicy(ctx, "workspaceProductPolicy", &apimanagement.WorkspaceProductPolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatXml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ProductId:         pulumi.String("5702e97e5157a50f48dce801"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<policies>
 *   <inbound>
 *     <rate-limit calls="{{call-count}}" renewal-period="15"></rate-limit>
 *     <log-to-eventhub logger-id="16">
 *                       @( string.Join(",", DateTime.UtcNow, context.Deployment.ServiceName, context.RequestId, context.Request.IpAddress, context.Operation.Name) )
 *                   </log-to-eventhub>
 *     <quota-by-key calls="40" counter-key="cc" renewal-period="3600" increment-count="@(context.Request.Method == &quot;POST&quot; ? 1:2)" />
 *     <base />
 *   </inbound>
 *   <backend>
 *     <base />
 *   </backend>
 *   <outbound>
 *     <base />
 *   </outbound>
 * </policies>`),
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceProductPolicy;
 * import com.pulumi.azurenative.apimanagement.WorkspaceProductPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceProductPolicy = new WorkspaceProductPolicy("workspaceProductPolicy", WorkspaceProductPolicyArgs.builder()
 *             .format("xml")
 *             .policyId("policy")
 *             .productId("5702e97e5157a50f48dce801")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("""
 * <policies>
 *   <inbound>
 *     <rate-limit calls="{{call-count}}" renewal-period="15"></rate-limit>
 *     <log-to-eventhub logger-id="16">
 *                       @( string.Join(",", DateTime.UtcNow, context.Deployment.ServiceName, context.RequestId, context.Request.IpAddress, context.Operation.Name) )
 *                   </log-to-eventhub>
 *     <quota-by-key calls="40" counter-key="cc" renewal-period="3600" increment-count="@(context.Request.Method == &quot;POST&quot; ? 1:2)" />
 *     <base />
 *   </inbound>
 *   <backend>
 *     <base />
 *   </backend>
 *   <outbound>
 *     <base />
 *   </outbound>
 * </policies>            """)
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceProductPolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/products/{productId}/policies/{policyId}
 * ```
 */
public class WorkspaceProductPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspaceProductPolicy,
) : KotlinCustomResource(javaResource, WorkspaceProductPolicyMapper) {
    /**
     * Format of the policyContent.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Contents of the Policy as defined by the format.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object WorkspaceProductPolicyMapper : ResourceMapper<WorkspaceProductPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceProductPolicy::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceProductPolicy =
        WorkspaceProductPolicy(
            javaResource as
                com.pulumi.azurenative.apimanagement.WorkspaceProductPolicy,
        )
}

/**
 * @see [WorkspaceProductPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceProductPolicy].
 */
public suspend fun workspaceProductPolicy(
    name: String,
    block: suspend WorkspaceProductPolicyResourceBuilder.() -> Unit,
): WorkspaceProductPolicy {
    val builder = WorkspaceProductPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceProductPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceProductPolicy(name: String): WorkspaceProductPolicy {
    val builder = WorkspaceProductPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
