@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceSubscriptionArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.SubscriptionState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subscription details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceSubscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceSubscription = new AzureNative.ApiManagement.WorkspaceSubscription("workspaceSubscription", new()
 *     {
 *         DisplayName = "testsub",
 *         OwnerId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/57127d485157a511ace86ae7",
 *         ResourceGroupName = "rg1",
 *         Scope = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/products/5600b59475ff190048060002",
 *         ServiceName = "apimService1",
 *         Sid = "testsub",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceSubscription(ctx, "workspaceSubscription", &apimanagement.WorkspaceSubscriptionArgs{
 * 			DisplayName:       pulumi.String("testsub"),
 * 			OwnerId:           pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/57127d485157a511ace86ae7"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Scope:             pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/products/5600b59475ff190048060002"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Sid:               pulumi.String("testsub"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceSubscription;
 * import com.pulumi.azurenative.apimanagement.WorkspaceSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceSubscription = new WorkspaceSubscription("workspaceSubscription", WorkspaceSubscriptionArgs.builder()
 *             .displayName("testsub")
 *             .ownerId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/57127d485157a511ace86ae7")
 *             .resourceGroupName("rg1")
 *             .scope("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/products/5600b59475ff190048060002")
 *             .serviceName("apimService1")
 *             .sid("testsub")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceSubscription testsub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/subscriptions/{sid}
 * ```
 * @property allowTracing Determines whether tracing can be enabled
 * @property appType Determines the type of application which send the create user request. Default is legacy publisher portal.
 * @property displayName Subscription name.
 * @property notify Notify change in Subscription State.
 *  - If false, do not send any email notification for change of state of subscription
 *  - If true, send email notification of change of state of subscription
 * @property ownerId User (user id path) for whom subscription is being created in form /users/{userId}
 * @property primaryKey Primary subscription key. If not specified during request key will be generated automatically.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope Scope like /products/{productId} or /apis or /apis/{apiId}.
 * @property secondaryKey Secondary subscription key. If not specified during request key will be generated automatically.
 * @property serviceName The name of the API Management service.
 * @property sid Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
 * @property state Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceSubscriptionArgs(
    public val allowTracing: Output<Boolean>? = null,
    public val appType: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val notify: Output<Boolean>? = null,
    public val ownerId: Output<String>? = null,
    public val primaryKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val secondaryKey: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val state: Output<SubscriptionState>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceSubscriptionArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceSubscriptionArgs.builder()
            .allowTracing(allowTracing?.applyValue({ args0 -> args0 }))
            .appType(appType?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .notify_(notify?.applyValue({ args0 -> args0 }))
            .ownerId(ownerId?.applyValue({ args0 -> args0 }))
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .secondaryKey(secondaryKey?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceSubscriptionArgs].
 */
@PulumiTagMarker
public class WorkspaceSubscriptionArgsBuilder internal constructor() {
    private var allowTracing: Output<Boolean>? = null

    private var appType: Output<String>? = null

    private var displayName: Output<String>? = null

    private var notify: Output<Boolean>? = null

    private var ownerId: Output<String>? = null

    private var primaryKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var secondaryKey: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sid: Output<String>? = null

    private var state: Output<SubscriptionState>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Determines whether tracing can be enabled
     */
    @JvmName("gcyldtvrfkamsyad")
    public suspend fun allowTracing(`value`: Output<Boolean>) {
        this.allowTracing = value
    }

    /**
     * @param value Determines the type of application which send the create user request. Default is legacy publisher portal.
     */
    @JvmName("jxaxwsimdvqgrjxt")
    public suspend fun appType(`value`: Output<String>) {
        this.appType = value
    }

    /**
     * @param value Subscription name.
     */
    @JvmName("dupssvgcvqeanmis")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Notify change in Subscription State.
     *  - If false, do not send any email notification for change of state of subscription
     *  - If true, send email notification of change of state of subscription
     */
    @JvmName("rltmujingfalwqht")
    public suspend fun notify(`value`: Output<Boolean>) {
        this.notify = value
    }

    /**
     * @param value User (user id path) for whom subscription is being created in form /users/{userId}
     */
    @JvmName("bramjvyptpsdapoe")
    public suspend fun ownerId(`value`: Output<String>) {
        this.ownerId = value
    }

    /**
     * @param value Primary subscription key. If not specified during request key will be generated automatically.
     */
    @JvmName("jlxeaesvyxtwwnuh")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rfkudwwwgkmthpbp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Scope like /products/{productId} or /apis or /apis/{apiId}.
     */
    @JvmName("uixqulxkhwagfntu")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Secondary subscription key. If not specified during request key will be generated automatically.
     */
    @JvmName("fipbngevbqsoende")
    public suspend fun secondaryKey(`value`: Output<String>) {
        this.secondaryKey = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ckesdnulbecfkibr")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     */
    @JvmName("ttryxgjkixkhrpkj")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
     */
    @JvmName("kskcrkgpsqdsfeyt")
    public suspend fun state(`value`: Output<SubscriptionState>) {
        this.state = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("eyeklqkjjmwvuyuh")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Determines whether tracing can be enabled
     */
    @JvmName("lnghixoguijqglma")
    public suspend fun allowTracing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowTracing = mapped
    }

    /**
     * @param value Determines the type of application which send the create user request. Default is legacy publisher portal.
     */
    @JvmName("rnxserkajumullau")
    public suspend fun appType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value Subscription name.
     */
    @JvmName("ikbnwoccanodjoev")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Notify change in Subscription State.
     *  - If false, do not send any email notification for change of state of subscription
     *  - If true, send email notification of change of state of subscription
     */
    @JvmName("aytafjqjqaktbwtu")
    public suspend fun notify(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notify = mapped
    }

    /**
     * @param value User (user id path) for whom subscription is being created in form /users/{userId}
     */
    @JvmName("pljydurevdipavrm")
    public suspend fun ownerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerId = mapped
    }

    /**
     * @param value Primary subscription key. If not specified during request key will be generated automatically.
     */
    @JvmName("mcjpmedlitcbowhe")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ejunjwmpuulelkqd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Scope like /products/{productId} or /apis or /apis/{apiId}.
     */
    @JvmName("ambqktbtewudsshj")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Secondary subscription key. If not specified during request key will be generated automatically.
     */
    @JvmName("ydvuqdgxcjaryqhr")
    public suspend fun secondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryKey = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("frmhnqtvlyiblaqn")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     */
    @JvmName("impatnhlapeiapwn")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
     */
    @JvmName("tsfoevgdiarjaqws")
    public suspend fun state(`value`: SubscriptionState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("tqkbkswiatqjvfms")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceSubscriptionArgs = WorkspaceSubscriptionArgs(
        allowTracing = allowTracing,
        appType = appType,
        displayName = displayName,
        notify = notify,
        ownerId = ownerId,
        primaryKey = primaryKey,
        resourceGroupName = resourceGroupName,
        scope = scope,
        secondaryKey = secondaryKey,
        serviceName = serviceName,
        sid = sid,
        state = state,
        workspaceId = workspaceId,
    )
}
