@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Authorization type options
 */
public enum class AuthorizationType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.AuthorizationType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.AuthorizationType> {
    /**
     * OAuth2 authorization type
     */
    OAuth2(com.pulumi.azurenative.apimanagement.enums.AuthorizationType.OAuth2),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.AuthorizationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.AuthorizationType):
            AuthorizationType = AuthorizationType.values().first { it.javaValue == javaType }
    }
}
