@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Backend communication protocol.
 */
public enum class BackendProtocol(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.BackendProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.BackendProtocol> {
    /**
     * The Backend is a RESTful service.
     */
    Http(com.pulumi.azurenative.apimanagement.enums.BackendProtocol.Http),

    /**
     * The Backend is a SOAP service.
     */
    Soap(com.pulumi.azurenative.apimanagement.enums.BackendProtocol.Soap),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.BackendProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.BackendProtocol):
            BackendProtocol = BackendProtocol.values().first { it.javaValue == javaType }
    }
}
