@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.apimanagement.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.apimanagement.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
