@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiVersionConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Control Plane Apis version constraint for the API Management service.
 * @property minApiVersion Limit control plane API calls to API Management service with version equal to or newer than this value.
 */
public data class ApiVersionConstraintArgs(
    public val minApiVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiVersionConstraintArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.ApiVersionConstraintArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiVersionConstraintArgs.builder()
            .minApiVersion(minApiVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiVersionConstraintArgs].
 */
@PulumiTagMarker
public class ApiVersionConstraintArgsBuilder internal constructor() {
    private var minApiVersion: Output<String>? = null

    /**
     * @param value Limit control plane API calls to API Management service with version equal to or newer than this value.
     */
    @JvmName("jlyonfvefyvwrlxi")
    public suspend fun minApiVersion(`value`: Output<String>) {
        this.minApiVersion = value
    }

    /**
     * @param value Limit control plane API calls to API Management service with version equal to or newer than this value.
     */
    @JvmName("rpefgrjboymqdkxh")
    public suspend fun minApiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minApiVersion = mapped
    }

    internal fun build(): ApiVersionConstraintArgs = ApiVersionConstraintArgs(
        minApiVersion = minApiVersion,
    )
}
