@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BackendPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties specific to the Backend Type.
 * @property serviceFabricCluster Backend Service Fabric Cluster Properties
 */
public data class BackendPropertiesArgs(
    public val serviceFabricCluster: Output<BackendServiceFabricClusterPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BackendPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.BackendPropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.BackendPropertiesArgs.builder()
            .serviceFabricCluster(
                serviceFabricCluster?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BackendPropertiesArgs].
 */
@PulumiTagMarker
public class BackendPropertiesArgsBuilder internal constructor() {
    private var serviceFabricCluster: Output<BackendServiceFabricClusterPropertiesArgs>? = null

    /**
     * @param value Backend Service Fabric Cluster Properties
     */
    @JvmName("tiorbkdppykoxhxg")
    public suspend
    fun serviceFabricCluster(`value`: Output<BackendServiceFabricClusterPropertiesArgs>) {
        this.serviceFabricCluster = value
    }

    /**
     * @param value Backend Service Fabric Cluster Properties
     */
    @JvmName("shxslbffufhklnqe")
    public suspend fun serviceFabricCluster(`value`: BackendServiceFabricClusterPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceFabricCluster = mapped
    }

    /**
     * @param argument Backend Service Fabric Cluster Properties
     */
    @JvmName("ykoqawodjtqussyh")
    public suspend
    fun serviceFabricCluster(argument: suspend BackendServiceFabricClusterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BackendServiceFabricClusterPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceFabricCluster = mapped
    }

    internal fun build(): BackendPropertiesArgs = BackendPropertiesArgs(
        serviceFabricCluster = serviceFabricCluster,
    )
}
