@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BackendProxyContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the Backend WebProxy Server to use in the Request to Backend.
 * @property password Password to connect to the WebProxy Server
 * @property url WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
 * @property username Username to connect to the WebProxy server
 */
public data class BackendProxyContractArgs(
    public val password: Output<String>? = null,
    public val url: Output<String>,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BackendProxyContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.BackendProxyContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.BackendProxyContractArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendProxyContractArgs].
 */
@PulumiTagMarker
public class BackendProxyContractArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var url: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Password to connect to the WebProxy Server
     */
    @JvmName("dxxwvdvlfcxbacqs")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
     */
    @JvmName("qvbubytgfdfkcxbh")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Username to connect to the WebProxy server
     */
    @JvmName("vcjtewukwgqnfdxc")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Password to connect to the WebProxy Server
     */
    @JvmName("tivyvfxoyhqolkqg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
     */
    @JvmName("pjlvoihihrtnssoi")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Username to connect to the WebProxy server
     */
    @JvmName("drsjnjujevlarqtr")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): BackendProxyContractArgs = BackendProxyContractArgs(
        password = password,
        url = url ?: throw PulumiNullFieldException("url"),
        username = username,
    )
}
