@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.CertificateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Certificate configuration which consist of non-trusted intermediates and root certificates.
 * @property certificate Certificate information.
 * @property certificatePassword Certificate Password.
 * @property encodedCertificate Base64 Encoded certificate.
 * @property storeName The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
 */
public data class CertificateConfigurationArgs(
    public val certificate: Output<CertificateInformationArgs>? = null,
    public val certificatePassword: Output<String>? = null,
    public val encodedCertificate: Output<String>? = null,
    public val storeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.CertificateConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.CertificateConfigurationArgs =
        com.pulumi.azurenative.apimanagement.inputs.CertificateConfigurationArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .certificatePassword(certificatePassword?.applyValue({ args0 -> args0 }))
            .encodedCertificate(encodedCertificate?.applyValue({ args0 -> args0 }))
            .storeName(storeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateConfigurationArgs].
 */
@PulumiTagMarker
public class CertificateConfigurationArgsBuilder internal constructor() {
    private var certificate: Output<CertificateInformationArgs>? = null

    private var certificatePassword: Output<String>? = null

    private var encodedCertificate: Output<String>? = null

    private var storeName: Output<String>? = null

    /**
     * @param value Certificate information.
     */
    @JvmName("doevnlrwpssvovxa")
    public suspend fun certificate(`value`: Output<CertificateInformationArgs>) {
        this.certificate = value
    }

    /**
     * @param value Certificate Password.
     */
    @JvmName("vufqbvtqfpoelkqh")
    public suspend fun certificatePassword(`value`: Output<String>) {
        this.certificatePassword = value
    }

    /**
     * @param value Base64 Encoded certificate.
     */
    @JvmName("cgeoojtpnjfuxjsb")
    public suspend fun encodedCertificate(`value`: Output<String>) {
        this.encodedCertificate = value
    }

    /**
     * @param value The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
     */
    @JvmName("drscgftdrtflcaqm")
    public suspend fun storeName(`value`: Output<String>) {
        this.storeName = value
    }

    /**
     * @param value Certificate information.
     */
    @JvmName("blmqhbnwbvockbdn")
    public suspend fun certificate(`value`: CertificateInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param argument Certificate information.
     */
    @JvmName("hstpyohetchnaoli")
    public suspend fun certificate(argument: suspend CertificateInformationArgsBuilder.() -> Unit) {
        val toBeMapped = CertificateInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificate = mapped
    }

    /**
     * @param value Certificate Password.
     */
    @JvmName("kbwimqdekphbahei")
    public suspend fun certificatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificatePassword = mapped
    }

    /**
     * @param value Base64 Encoded certificate.
     */
    @JvmName("qqioagwjtryjnxbv")
    public suspend fun encodedCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedCertificate = mapped
    }

    /**
     * @param value The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
     */
    @JvmName("wuuufgsenhisdrae")
    public suspend fun storeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storeName = mapped
    }

    internal fun build(): CertificateConfigurationArgs = CertificateConfigurationArgs(
        certificate = certificate,
        certificatePassword = certificatePassword,
        encodedCertificate = encodedCertificate,
        storeName = storeName ?: throw PulumiNullFieldException("storeName"),
    )
}
