@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetEmailTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property templateName Email Template Name Identifier.
 */
public data class GetEmailTemplatePlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val templateName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetEmailTemplatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetEmailTemplatePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetEmailTemplatePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .templateName(templateName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEmailTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetEmailTemplatePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var templateName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxgbdshjwbeldxvk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vaveeryltfqiymqh")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Email Template Name Identifier.
     */
    @JvmName("hgswmndcbqlrhmud")
    public suspend fun templateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templateName = mapped
    }

    internal fun build(): GetEmailTemplatePlainArgs = GetEmailTemplatePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        templateName = templateName ?: throw PulumiNullFieldException("templateName"),
    )
}
