@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetTagByOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property operationId Operation identifier within an API. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 */
public data class GetTagByOperationPlainArgs(
    public val apiId: String,
    public val operationId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val tagId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetTagByOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetTagByOperationPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetTagByOperationPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .operationId(operationId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .tagId(tagId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagByOperationPlainArgs].
 */
@PulumiTagMarker
public class GetTagByOperationPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var operationId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var tagId: String? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("kmwxgwesiknwpclh")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Operation identifier within an API. Must be unique in the current API Management service instance.
     */
    @JvmName("romwbnuniueskexi")
    public suspend fun operationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operationId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qsastlfwtxkrglmp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("abhplvnejxfrilmm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("qklwlqbbrvbbbsrp")
    public suspend fun tagId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagId = mapped
    }

    internal fun build(): GetTagByOperationPlainArgs = GetTagByOperationPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        operationId = operationId ?: throw PulumiNullFieldException("operationId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        tagId = tagId ?: throw PulumiNullFieldException("tagId"),
    )
}
