@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ListOpenIdConnectProviderSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property opid Identifier of the OpenID Connect Provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ListOpenIdConnectProviderSecretsPlainArgs(
    public val opid: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ListOpenIdConnectProviderSecretsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ListOpenIdConnectProviderSecretsPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.ListOpenIdConnectProviderSecretsPlainArgs.builder()
            .opid(opid.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListOpenIdConnectProviderSecretsPlainArgs].
 */
@PulumiTagMarker
public class ListOpenIdConnectProviderSecretsPlainArgsBuilder internal constructor() {
    private var opid: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identifier of the OpenID Connect Provider.
     */
    @JvmName("vfbymsebciphbcsv")
    public suspend fun opid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.opid = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ywjkxohjnjighnmv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("gxddskqlbsuemssl")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): ListOpenIdConnectProviderSecretsPlainArgs =
        ListOpenIdConnectProviderSecretsPlainArgs(
            opid = opid ?: throw PulumiNullFieldException("opid"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
