@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ListWorkspaceNamedValuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namedValueId Identifier of the NamedValue.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class ListWorkspaceNamedValuePlainArgs(
    public val namedValueId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ListWorkspaceNamedValuePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ListWorkspaceNamedValuePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.ListWorkspaceNamedValuePlainArgs.builder()
            .namedValueId(namedValueId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkspaceNamedValuePlainArgs].
 */
@PulumiTagMarker
public class ListWorkspaceNamedValuePlainArgsBuilder internal constructor() {
    private var namedValueId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value Identifier of the NamedValue.
     */
    @JvmName("jinbrguhriunkeow")
    public suspend fun namedValueId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namedValueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ogpfcalmqtccoaiv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ycmbbeyovaaeshso")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("qhekgggbwffavvno")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): ListWorkspaceNamedValuePlainArgs = ListWorkspaceNamedValuePlainArgs(
        namedValueId = namedValueId ?: throw PulumiNullFieldException("namedValueId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
