@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ParameterContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Operation parameters details.
 * @property defaultValue Default parameter value.
 * @property description Parameter description.
 * @property examples Exampled defined for the parameter.
 * @property name Parameter name.
 * @property required Specifies whether parameter is required or not.
 * @property schemaId Schema identifier.
 * @property type Parameter type.
 * @property typeName Type name defined by the schema.
 * @property values Parameter values.
 */
public data class ParameterContractArgs(
    public val defaultValue: Output<String>? = null,
    public val description: Output<String>? = null,
    public val examples: Output<Map<String, ParameterExampleContractArgs>>? = null,
    public val name: Output<String>,
    public val required: Output<Boolean>? = null,
    public val schemaId: Output<String>? = null,
    public val type: Output<String>,
    public val typeName: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ParameterContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.ParameterContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.ParameterContractArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .examples(
                examples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .required(required?.applyValue({ args0 -> args0 }))
            .schemaId(schemaId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .typeName(typeName?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ParameterContractArgs].
 */
@PulumiTagMarker
public class ParameterContractArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var description: Output<String>? = null

    private var examples: Output<Map<String, ParameterExampleContractArgs>>? = null

    private var name: Output<String>? = null

    private var required: Output<Boolean>? = null

    private var schemaId: Output<String>? = null

    private var type: Output<String>? = null

    private var typeName: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Default parameter value.
     */
    @JvmName("jukcmlgixdebcirk")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value Parameter description.
     */
    @JvmName("jsmpxpghmjeoapac")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Exampled defined for the parameter.
     */
    @JvmName("dxwcixigolalpwpm")
    public suspend fun examples(`value`: Output<Map<String, ParameterExampleContractArgs>>) {
        this.examples = value
    }

    /**
     * @param value Parameter name.
     */
    @JvmName("nirelqyuamcxknat")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether parameter is required or not.
     */
    @JvmName("qjigvkbekiriewnp")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Schema identifier.
     */
    @JvmName("itgsxdshbmsmhmnt")
    public suspend fun schemaId(`value`: Output<String>) {
        this.schemaId = value
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("cnrfrhciabgjkkbf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Type name defined by the schema.
     */
    @JvmName("ualomhfexjwbgoml")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Parameter values.
     */
    @JvmName("wghfcxpqnhwcuyye")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("fhnttwepsmyreikc")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Parameter values.
     */
    @JvmName("vmbgyrkcrwpwkmxc")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Default parameter value.
     */
    @JvmName("kbgfeebfclkuexkr")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Parameter description.
     */
    @JvmName("dahyrbhgtmfoweli")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Exampled defined for the parameter.
     */
    @JvmName("kpbyohwpkkkiwxwp")
    public suspend fun examples(`value`: Map<String, ParameterExampleContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.examples = mapped
    }

    /**
     * @param argument Exampled defined for the parameter.
     */
    @JvmName("dgifdwnqvevycqxt")
    public suspend fun examples(
        vararg
        argument: Pair<String, suspend ParameterExampleContractArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterExampleContractArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.examples = mapped
    }

    /**
     * @param values Exampled defined for the parameter.
     */
    @JvmName("utkhqbpxoklbprqy")
    public fun examples(vararg values: Pair<String, ParameterExampleContractArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.examples = mapped
    }

    /**
     * @param value Parameter name.
     */
    @JvmName("gbalftcebjlxwcut")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether parameter is required or not.
     */
    @JvmName("ktlrilybfityqbsd")
    public suspend fun required(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.required = mapped
    }

    /**
     * @param value Schema identifier.
     */
    @JvmName("iecxokgxmggrvgap")
    public suspend fun schemaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaId = mapped
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("cfwpbhtbtdgaujuu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type name defined by the schema.
     */
    @JvmName("ifwhkmubkrrmvvkc")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value Parameter values.
     */
    @JvmName("urorvoylpuhsuhvm")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Parameter values.
     */
    @JvmName("sjgrtbgvxpatwuiu")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ParameterContractArgs = ParameterContractArgs(
        defaultValue = defaultValue,
        description = description,
        examples = examples,
        name = name ?: throw PulumiNullFieldException("name"),
        required = required,
        schemaId = schemaId,
        type = type ?: throw PulumiNullFieldException("type"),
        typeName = typeName,
        values = values,
    )
}
