@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ResponseContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Operation response details.
 * @property description Operation response description.
 * @property headers Collection of operation response headers.
 * @property representations Collection of operation response representations.
 * @property statusCode Operation response HTTP status code.
 */
public data class ResponseContractArgs(
    public val description: Output<String>? = null,
    public val headers: Output<List<ParameterContractArgs>>? = null,
    public val representations: Output<List<RepresentationContractArgs>>? = null,
    public val statusCode: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ResponseContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.ResponseContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.ResponseContractArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .representations(
                representations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statusCode(statusCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseContractArgs].
 */
@PulumiTagMarker
public class ResponseContractArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var headers: Output<List<ParameterContractArgs>>? = null

    private var representations: Output<List<RepresentationContractArgs>>? = null

    private var statusCode: Output<Int>? = null

    /**
     * @param value Operation response description.
     */
    @JvmName("ckfynspbsliwntye")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Collection of operation response headers.
     */
    @JvmName("lrbktmocchueijuf")
    public suspend fun headers(`value`: Output<List<ParameterContractArgs>>) {
        this.headers = value
    }

    @JvmName("qdcsaqkhhtbasfig")
    public suspend fun headers(vararg values: Output<ParameterContractArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Collection of operation response headers.
     */
    @JvmName("iydpageuhhnrxvpc")
    public suspend fun headers(values: List<Output<ParameterContractArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Collection of operation response representations.
     */
    @JvmName("vabqgougaolxrlog")
    public suspend fun representations(`value`: Output<List<RepresentationContractArgs>>) {
        this.representations = value
    }

    @JvmName("mkshrrtdgvrgdcvx")
    public suspend fun representations(vararg values: Output<RepresentationContractArgs>) {
        this.representations = Output.all(values.asList())
    }

    /**
     * @param values Collection of operation response representations.
     */
    @JvmName("vetkxxhoseecpqrk")
    public suspend fun representations(values: List<Output<RepresentationContractArgs>>) {
        this.representations = Output.all(values)
    }

    /**
     * @param value Operation response HTTP status code.
     */
    @JvmName("qxofctiatysjqnqf")
    public suspend fun statusCode(`value`: Output<Int>) {
        this.statusCode = value
    }

    /**
     * @param value Operation response description.
     */
    @JvmName("cqiqyfhctxrwvqcm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Collection of operation response headers.
     */
    @JvmName("hbydlqhvvhopnpic")
    public suspend fun headers(`value`: List<ParameterContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Collection of operation response headers.
     */
    @JvmName("ovtmldjdamosqnvs")
    public suspend fun headers(argument: List<suspend ParameterContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Collection of operation response headers.
     */
    @JvmName("kltqggtqnqmmvufq")
    public suspend fun headers(vararg argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Collection of operation response headers.
     */
    @JvmName("iiawkjorxfjdefft")
    public suspend fun headers(argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Collection of operation response headers.
     */
    @JvmName("asuwukmiylcfugde")
    public suspend fun headers(vararg values: ParameterContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Collection of operation response representations.
     */
    @JvmName("jxvhlabfyxpxpxwo")
    public suspend fun representations(`value`: List<RepresentationContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.representations = mapped
    }

    /**
     * @param argument Collection of operation response representations.
     */
    @JvmName("vowfjqsulcissdvo")
    public suspend
    fun representations(argument: List<suspend RepresentationContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RepresentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.representations = mapped
    }

    /**
     * @param argument Collection of operation response representations.
     */
    @JvmName("yshyrwifoaaqhydv")
    public suspend fun representations(
        vararg
        argument: suspend RepresentationContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RepresentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.representations = mapped
    }

    /**
     * @param argument Collection of operation response representations.
     */
    @JvmName("mbnjhhugunjothjw")
    public suspend
    fun representations(argument: suspend RepresentationContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RepresentationContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.representations = mapped
    }

    /**
     * @param values Collection of operation response representations.
     */
    @JvmName("xtnicibwsdtiwtdd")
    public suspend fun representations(vararg values: RepresentationContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.representations = mapped
    }

    /**
     * @param value Operation response HTTP status code.
     */
    @JvmName("bbrbeopogwjdvdet")
    public suspend fun statusCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ResponseContractArgs = ResponseContractArgs(
        description = description,
        headers = headers,
        representations = representations,
        statusCode = statusCode ?: throw PulumiNullFieldException("statusCode"),
    )
}
