@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.X509CertificateNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of server X509Names.
 * @property issuerCertificateThumbprint Thumbprint for the Issuer of the Certificate.
 * @property name Common Name of the Certificate.
 */
public data class X509CertificateNameArgs(
    public val issuerCertificateThumbprint: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.X509CertificateNameArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.X509CertificateNameArgs =
        com.pulumi.azurenative.apimanagement.inputs.X509CertificateNameArgs.builder()
            .issuerCertificateThumbprint(issuerCertificateThumbprint?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X509CertificateNameArgs].
 */
@PulumiTagMarker
public class X509CertificateNameArgsBuilder internal constructor() {
    private var issuerCertificateThumbprint: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Thumbprint for the Issuer of the Certificate.
     */
    @JvmName("pvcstsegxbexwlqe")
    public suspend fun issuerCertificateThumbprint(`value`: Output<String>) {
        this.issuerCertificateThumbprint = value
    }

    /**
     * @param value Common Name of the Certificate.
     */
    @JvmName("wbrfkltfqobmpqyo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Thumbprint for the Issuer of the Certificate.
     */
    @JvmName("njmchnklsssqwibj")
    public suspend fun issuerCertificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuerCertificateThumbprint = mapped
    }

    /**
     * @param value Common Name of the Certificate.
     */
    @JvmName("lidhfrwhgwjvlhhl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): X509CertificateNameArgs = X509CertificateNameArgs(
        issuerCertificateThumbprint = issuerCertificateThumbprint,
        name = name,
    )
}
