@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * API Authentication Settings.
 * @property oAuth2 OAuth2 Authentication settings
 * @property oAuth2AuthenticationSettings Collection of OAuth2 authentication settings included into this API.
 * @property openid OpenID Connect Authentication Settings
 * @property openidAuthenticationSettings Collection of Open ID Connect authentication settings included into this API.
 */
public data class AuthenticationSettingsContractResponse(
    public val oAuth2: OAuth2AuthenticationSettingsContractResponse? = null,
    public val oAuth2AuthenticationSettings: List<OAuth2AuthenticationSettingsContractResponse>? =
        null,
    public val openid: OpenIdAuthenticationSettingsContractResponse? = null,
    public val openidAuthenticationSettings: List<OpenIdAuthenticationSettingsContractResponse>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.AuthenticationSettingsContractResponse):
            AuthenticationSettingsContractResponse = AuthenticationSettingsContractResponse(
            oAuth2 = javaType.oAuth2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.OAuth2AuthenticationSettingsContractResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            oAuth2AuthenticationSettings = javaType.oAuth2AuthenticationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.OAuth2AuthenticationSettingsContractResponse.Companion.toKotlin(args0)
                })
            }),
            openid = javaType.openid().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.OpenIdAuthenticationSettingsContractResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            openidAuthenticationSettings = javaType.openidAuthenticationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.OpenIdAuthenticationSettingsContractResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
