@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Issue Attachment Contract details.
 * @property content An HTTP link or Base64-encoded binary data.
 * @property contentFormat Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided in the 'content' property.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property title Filename by which the binary data will be saved.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApiIssueAttachmentResult(
    public val content: String,
    public val contentFormat: String,
    public val id: String,
    public val name: String,
    public val title: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiIssueAttachmentResult):
            GetApiIssueAttachmentResult = GetApiIssueAttachmentResult(
            content = javaType.content(),
            contentFormat = javaType.contentFormat(),
            id = javaType.id(),
            name = javaType.name(),
            title = javaType.title(),
            type = javaType.type(),
        )
    }
}
