@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Issue Contract details.
 * @property apiId A resource identifier for the API the issue was created for.
 * @property createdDate Date and time when the issue was created.
 * @property description Text describing the issue.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property state Status of the issue.
 * @property title The issue title.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userId A resource identifier for the user created the issue.
 */
public data class GetApiIssueResult(
    public val apiId: String? = null,
    public val createdDate: String? = null,
    public val description: String,
    public val id: String,
    public val name: String,
    public val state: String? = null,
    public val title: String,
    public val type: String,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiIssueResult):
            GetApiIssueResult = GetApiIssueResult(
            apiId = javaType.apiId().map({ args0 -> args0 }).orElse(null),
            createdDate = javaType.createdDate().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            title = javaType.title(),
            type = javaType.type(),
            userId = javaType.userId(),
        )
    }
}
