@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A single API Management service resource in List or Get response.
 * @property additionalLocations Additional datacenter locations of the API Management service.
 * @property apiVersionConstraint Control Plane Apis version constraint for the API Management service.
 * @property certificates List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
 * @property createdAtUtc Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property customProperties Custom properties of the API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS 1.1 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0 for communications with backends.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For all the settings except Http2 the default value is `True` if the service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is `False`.</br></br>You can disable any of the following ciphers by using settings `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`: TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256, TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example, `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by internal platform components: TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
 * @property developerPortalUrl DEveloper Portal endpoint URL of the API Management service.
 * @property disableGateway Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in master region.
 * @property enableClientCertificate Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each request to the gateway. This also enables the ability to authenticate the certificate in the policy on the gateway.
 * @property etag ETag of the resource.
 * @property gatewayRegionalUrl Gateway URL of the API Management service in the Default Region.
 * @property gatewayUrl Gateway URL of the API Management service.
 * @property hostnameConfigurations Custom hostname configuration of the API Management service.
 * @property id Resource ID.
 * @property identity Managed service identity of the Api Management service.
 * @property location Resource location.
 * @property managementApiUrl Management API endpoint URL of the API Management service.
 * @property name Resource name.
 * @property natGatewayState Property can be used to enable NAT Gateway for this API Management service.
 * @property notificationSenderEmail Email address from which the notification will be sent.
 * @property outboundPublicIPAddresses Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium SKU on stv2 platform.
 * @property platformVersion Compute Platform Version running the service in this location.
 * @property portalUrl Publisher portal endpoint Url of the API Management service.
 * @property privateEndpointConnections List of Private Endpoint Connections of this service.
 * @property privateIPAddresses Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated SKU.
 * @property provisioningState The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
 * @property publicIPAddresses Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
 * @property publicIpAddressId Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual Network.
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this API Management service.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'
 * @property publisherEmail Publisher email.
 * @property publisherName Publisher name.
 * @property restore Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other properties will be ignored.
 * @property scmUrl SCM endpoint URL of the API Management service.
 * @property sku SKU properties of the API Management service.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property targetProvisioningState The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
 * @property type Resource type for API Management resource is set to Microsoft.ApiManagement.
 * @property virtualNetworkConfiguration Virtual network configuration of the API Management service.
 * @property virtualNetworkType The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class GetApiManagementServiceResult(
    public val additionalLocations: List<AdditionalLocationResponse>? = null,
    public val apiVersionConstraint: ApiVersionConstraintResponse? = null,
    public val certificates: List<CertificateConfigurationResponse>? = null,
    public val createdAtUtc: String,
    public val customProperties: Map<String, String>? = null,
    public val developerPortalUrl: String,
    public val disableGateway: Boolean? = null,
    public val enableClientCertificate: Boolean? = null,
    public val etag: String,
    public val gatewayRegionalUrl: String,
    public val gatewayUrl: String,
    public val hostnameConfigurations: List<HostnameConfigurationResponse>? = null,
    public val id: String,
    public val identity: ApiManagementServiceIdentityResponse? = null,
    public val location: String,
    public val managementApiUrl: String,
    public val name: String,
    public val natGatewayState: String? = null,
    public val notificationSenderEmail: String? = null,
    public val outboundPublicIPAddresses: List<String>,
    public val platformVersion: String,
    public val portalUrl: String,
    public val privateEndpointConnections: List<RemotePrivateEndpointConnectionWrapperResponse>? =
        null,
    public val privateIPAddresses: List<String>,
    public val provisioningState: String,
    public val publicIPAddresses: List<String>,
    public val publicIpAddressId: String? = null,
    public val publicNetworkAccess: String? = null,
    public val publisherEmail: String,
    public val publisherName: String,
    public val restore: Boolean? = null,
    public val scmUrl: String,
    public val sku: ApiManagementServiceSkuPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetProvisioningState: String,
    public val type: String,
    public val virtualNetworkConfiguration: VirtualNetworkConfigurationResponse? = null,
    public val virtualNetworkType: String? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetApiManagementServiceResult):
            GetApiManagementServiceResult = GetApiManagementServiceResult(
            additionalLocations = javaType.additionalLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.AdditionalLocationResponse.Companion.toKotlin(args0)
                })
            }),
            apiVersionConstraint = javaType.apiVersionConstraint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionConstraintResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.CertificateConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            createdAtUtc = javaType.createdAtUtc(),
            customProperties = javaType.customProperties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            developerPortalUrl = javaType.developerPortalUrl(),
            disableGateway = javaType.disableGateway().map({ args0 -> args0 }).orElse(null),
            enableClientCertificate = javaType.enableClientCertificate().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            gatewayRegionalUrl = javaType.gatewayRegionalUrl(),
            gatewayUrl = javaType.gatewayUrl(),
            hostnameConfigurations = javaType.hostnameConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.HostnameConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            managementApiUrl = javaType.managementApiUrl(),
            name = javaType.name(),
            natGatewayState = javaType.natGatewayState().map({ args0 -> args0 }).orElse(null),
            notificationSenderEmail = javaType.notificationSenderEmail().map({ args0 -> args0 }).orElse(null),
            outboundPublicIPAddresses = javaType.outboundPublicIPAddresses().map({ args0 -> args0 }),
            platformVersion = javaType.platformVersion(),
            portalUrl = javaType.portalUrl(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.RemotePrivateEndpointConnectionWrapperResponse.Companion.toKotlin(args0)
                })
            }),
            privateIPAddresses = javaType.privateIPAddresses().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            publicIPAddresses = javaType.publicIPAddresses().map({ args0 -> args0 }),
            publicIpAddressId = javaType.publicIpAddressId().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            publisherEmail = javaType.publisherEmail(),
            publisherName = javaType.publisherName(),
            restore = javaType.restore().map({ args0 -> args0 }).orElse(null),
            scmUrl = javaType.scmUrl(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceSkuPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.apimanagement.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetProvisioningState = javaType.targetProvisioningState(),
            type = javaType.type(),
            virtualNetworkConfiguration = javaType.virtualNetworkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.VirtualNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualNetworkType = javaType.virtualNetworkType().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
