@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Contract details.
 * @property builtIn true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
 * @property description Group description. Can contain HTML formatting tags.
 * @property displayName Group name.
 * @property externalId For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGroupResult(
    public val builtIn: Boolean,
    public val description: String? = null,
    public val displayName: String,
    public val externalId: String? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetGroupResult):
            GetGroupResult = GetGroupResult(
            builtIn = javaType.builtIn(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            externalId = javaType.externalId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
