@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Policy fragment contract details.
 * @property description Policy fragment description.
 * @property format Format of the policy fragment content.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Contents of the policy fragment.
 */
public data class GetPolicyFragmentResult(
    public val description: String? = null,
    public val format: String? = null,
    public val id: String,
    public val name: String,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetPolicyFragmentResult):
            GetPolicyFragmentResult = GetPolicyFragmentResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
