@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Subscription details.
 * @property allowTracing Determines whether tracing is enabled
 * @property createdDate Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property displayName The name of the subscription, or null if the subscription has no name.
 * @property endDate Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is not automatically cancelled. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property expirationDate Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property notificationDate Upcoming subscription expiration notification date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property ownerId The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{userId} where {userId} is a user identifier.
 * @property primaryKey Subscription primary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property scope Scope like /products/{productId} or /apis or /apis/{apiId}.
 * @property secondaryKey Subscription secondary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property startDate Subscription activation date. The setting is for audit purposes only and the subscription is not automatically activated. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property state Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
 * @property stateComment Optional subscription comment added by an administrator when the state is changed to the 'rejected'.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSubscriptionResult(
    public val allowTracing: Boolean? = null,
    public val createdDate: String,
    public val displayName: String? = null,
    public val endDate: String? = null,
    public val expirationDate: String? = null,
    public val id: String,
    public val name: String,
    public val notificationDate: String? = null,
    public val ownerId: String? = null,
    public val primaryKey: String? = null,
    public val scope: String,
    public val secondaryKey: String? = null,
    public val startDate: String? = null,
    public val state: String,
    public val stateComment: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetSubscriptionResult):
            GetSubscriptionResult = GetSubscriptionResult(
            allowTracing = javaType.allowTracing().map({ args0 -> args0 }).orElse(null),
            createdDate = javaType.createdDate(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            notificationDate = javaType.notificationDate().map({ args0 -> args0 }).orElse(null),
            ownerId = javaType.ownerId().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope(),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
            startDate = javaType.startDate().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            stateComment = javaType.stateComment().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
