@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Http message diagnostic settings.
 * @property body Body logging settings.
 * @property dataMasking Data masking settings.
 * @property headers Array of HTTP Headers to log.
 */
public data class HttpMessageDiagnosticResponse(
    public val body: BodyDiagnosticSettingsResponse? = null,
    public val dataMasking: DataMaskingResponse? = null,
    public val headers: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.HttpMessageDiagnosticResponse):
            HttpMessageDiagnosticResponse = HttpMessageDiagnosticResponse(
            body = javaType.body().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.BodyDiagnosticSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataMasking = javaType.dataMasking().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.DataMaskingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0 }),
        )
    }
}
