@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Issue contract Update Properties.
 * @property code Last status code for sync and refresh of secret from key vault.
 * @property message Details of the error else empty.
 * @property timeStampUtc Last time secret was accessed. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 */
public data class KeyVaultLastAccessStatusContractPropertiesResponse(
    public val code: String? = null,
    public val message: String? = null,
    public val timeStampUtc: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.KeyVaultLastAccessStatusContractPropertiesResponse):
            KeyVaultLastAccessStatusContractPropertiesResponse =
            KeyVaultLastAccessStatusContractPropertiesResponse(
                code = javaType.code().map({ args0 -> args0 }).orElse(null),
                message = javaType.message().map({ args0 -> args0 }).orElse(null),
                timeStampUtc = javaType.timeStampUtc().map({ args0 -> args0 }).orElse(null),
            )
    }
}
