@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
 * @property clientSecret Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
 */
public data class ListIdentityProviderSecretsResult(
    public val clientSecret: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ListIdentityProviderSecretsResult):
            ListIdentityProviderSecretsResult = ListIdentityProviderSecretsResult(
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
