@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of resources.
 * @property count Total record count number.
 * @property nextLink Next page link if any.
 * @property value A collection of resources.
 */
public data class ListPolicyFragmentReferencesResult(
    public val count: Double? = null,
    public val nextLink: String? = null,
    public val `value`: List<ResourceCollectionResponseValue>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.ListPolicyFragmentReferencesResult):
            ListPolicyFragmentReferencesResult = ListPolicyFragmentReferencesResult(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.ResourceCollectionResponseValue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
