@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * API OAuth2 Authentication settings details.
 * @property bearerTokenSendingMethods How to send token to the server.
 * @property openidProviderId OAuth authorization server identifier.
 */
public data class OpenIdAuthenticationSettingsContractResponse(
    public val bearerTokenSendingMethods: List<String>? = null,
    public val openidProviderId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.OpenIdAuthenticationSettingsContractResponse):
            OpenIdAuthenticationSettingsContractResponse = OpenIdAuthenticationSettingsContractResponse(
            bearerTokenSendingMethods = javaType.bearerTokenSendingMethods().map({ args0 -> args0 }),
            openidProviderId = javaType.openidProviderId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
