@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.AppResiliencyArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.CircuitBreakerPolicyArgs
import com.pulumi.azurenative.app.kotlin.inputs.CircuitBreakerPolicyArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.HttpConnectionPoolArgs
import com.pulumi.azurenative.app.kotlin.inputs.HttpConnectionPoolArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.HttpRetryPolicyArgs
import com.pulumi.azurenative.app.kotlin.inputs.HttpRetryPolicyArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.TcpConnectionPoolArgs
import com.pulumi.azurenative.app.kotlin.inputs.TcpConnectionPoolArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.TcpRetryPolicyArgs
import com.pulumi.azurenative.app.kotlin.inputs.TcpRetryPolicyArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.TimeoutPolicyArgs
import com.pulumi.azurenative.app.kotlin.inputs.TimeoutPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration to setup App Resiliency
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update App Resiliency
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appResiliency = new AzureNative.App.AppResiliency("appResiliency", new()
 *     {
 *         AppName = "testcontainerApp0",
 *         CircuitBreakerPolicy = new AzureNative.App.Inputs.CircuitBreakerPolicyArgs
 *         {
 *             ConsecutiveErrors = 5,
 *             IntervalInSeconds = 10,
 *             MaxEjectionPercent = 50,
 *         },
 *         HttpConnectionPool = new AzureNative.App.Inputs.HttpConnectionPoolArgs
 *         {
 *             Http1MaxPendingRequests = 1024,
 *             Http2MaxRequests = 1024,
 *         },
 *         HttpRetryPolicy = new AzureNative.App.Inputs.HttpRetryPolicyArgs
 *         {
 *             Errors = new[]
 *             {
 *                 "5xx",
 *                 "connect-failure",
 *                 "reset",
 *                 "retriable-headers",
 *                 "retriable-status-codes",
 *             },
 *             Headers = new[]
 *             {
 *                 new AzureNative.App.Inputs.HeaderMatchArgs
 *                 {
 *                     Header = "X-Content-Type",
 *                     PrefixMatch = "GOATS",
 *                 },
 *             },
 *             HttpStatusCodes = new[]
 *             {
 *                 502,
 *                 503,
 *             },
 *             InitialDelayInMilliseconds = 1000,
 *             MaxIntervalInMilliseconds = 10000,
 *             MaxRetries = 5,
 *         },
 *         Name = "resiliency-policy-1",
 *         ResourceGroupName = "rg",
 *         TcpConnectionPool = new AzureNative.App.Inputs.TcpConnectionPoolArgs
 *         {
 *             MaxConnections = 100,
 *         },
 *         TcpRetryPolicy = new AzureNative.App.Inputs.TcpRetryPolicyArgs
 *         {
 *             MaxConnectAttempts = 3,
 *         },
 *         TimeoutPolicy = new AzureNative.App.Inputs.TimeoutPolicyArgs
 *         {
 *             ConnectionTimeoutInSeconds = 5,
 *             ResponseTimeoutInSeconds = 15,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewAppResiliency(ctx, "appResiliency", &app.AppResiliencyArgs{
 * 			AppName: pulumi.String("testcontainerApp0"),
 * 			CircuitBreakerPolicy: &app.CircuitBreakerPolicyArgs{
 * 				ConsecutiveErrors:  pulumi.Int(5),
 * 				IntervalInSeconds:  pulumi.Int(10),
 * 				MaxEjectionPercent: pulumi.Int(50),
 * 			},
 * 			HttpConnectionPool: &app.HttpConnectionPoolArgs{
 * 				Http1MaxPendingRequests: pulumi.Int(1024),
 * 				Http2MaxRequests:        pulumi.Int(1024),
 * 			},
 * 			HttpRetryPolicy: &app.HttpRetryPolicyArgs{
 * 				Errors: pulumi.StringArray{
 * 					pulumi.String("5xx"),
 * 					pulumi.String("connect-failure"),
 * 					pulumi.String("reset"),
 * 					pulumi.String("retriable-headers"),
 * 					pulumi.String("retriable-status-codes"),
 * 				},
 * 				Headers: app.HeaderMatchArray{
 * 					&app.HeaderMatchArgs{
 * 						Header:      pulumi.String("X-Content-Type"),
 * 						PrefixMatch: pulumi.String("GOATS"),
 * 					},
 * 				},
 * 				HttpStatusCodes: pulumi.IntArray{
 * 					pulumi.Int(502),
 * 					pulumi.Int(503),
 * 				},
 * 				InitialDelayInMilliseconds: pulumi.Float64(1000),
 * 				MaxIntervalInMilliseconds:  pulumi.Float64(10000),
 * 				MaxRetries:                 pulumi.Int(5),
 * 			},
 * 			Name:              pulumi.String("resiliency-policy-1"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			TcpConnectionPool: &app.TcpConnectionPoolArgs{
 * 				MaxConnections: pulumi.Int(100),
 * 			},
 * 			TcpRetryPolicy: &app.TcpRetryPolicyArgs{
 * 				MaxConnectAttempts: pulumi.Int(3),
 * 			},
 * 			TimeoutPolicy: &app.TimeoutPolicyArgs{
 * 				ConnectionTimeoutInSeconds: pulumi.Int(5),
 * 				ResponseTimeoutInSeconds:   pulumi.Int(15),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.AppResiliency;
 * import com.pulumi.azurenative.app.AppResiliencyArgs;
 * import com.pulumi.azurenative.app.inputs.CircuitBreakerPolicyArgs;
 * import com.pulumi.azurenative.app.inputs.HttpConnectionPoolArgs;
 * import com.pulumi.azurenative.app.inputs.HttpRetryPolicyArgs;
 * import com.pulumi.azurenative.app.inputs.TcpConnectionPoolArgs;
 * import com.pulumi.azurenative.app.inputs.TcpRetryPolicyArgs;
 * import com.pulumi.azurenative.app.inputs.TimeoutPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appResiliency = new AppResiliency("appResiliency", AppResiliencyArgs.builder()
 *             .appName("testcontainerApp0")
 *             .circuitBreakerPolicy(CircuitBreakerPolicyArgs.builder()
 *                 .consecutiveErrors(5)
 *                 .intervalInSeconds(10)
 *                 .maxEjectionPercent(50)
 *                 .build())
 *             .httpConnectionPool(HttpConnectionPoolArgs.builder()
 *                 .http1MaxPendingRequests(1024)
 *                 .http2MaxRequests(1024)
 *                 .build())
 *             .httpRetryPolicy(HttpRetryPolicyArgs.builder()
 *                 .errors(
 *                     "5xx",
 *                     "connect-failure",
 *                     "reset",
 *                     "retriable-headers",
 *                     "retriable-status-codes")
 *                 .headers(HeaderMatchArgs.builder()
 *                     .header("X-Content-Type")
 *                     .prefixMatch("GOATS")
 *                     .build())
 *                 .httpStatusCodes(
 *                     502,
 *                     503)
 *                 .initialDelayInMilliseconds(1000)
 *                 .maxIntervalInMilliseconds(10000)
 *                 .maxRetries(5)
 *                 .build())
 *             .name("resiliency-policy-1")
 *             .resourceGroupName("rg")
 *             .tcpConnectionPool(TcpConnectionPoolArgs.builder()
 *                 .maxConnections(100)
 *                 .build())
 *             .tcpRetryPolicy(TcpRetryPolicyArgs.builder()
 *                 .maxConnectAttempts(3)
 *                 .build())
 *             .timeoutPolicy(TimeoutPolicyArgs.builder()
 *                 .connectionTimeoutInSeconds(5)
 *                 .responseTimeoutInSeconds(15)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:AppResiliency resiliency-policy-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/containerApps/{appName}/resiliencyPolicies/{name}
 * ```
 * @property appName Name of the Container App.
 * @property circuitBreakerPolicy Policy that defines circuit breaker conditions
 * @property httpConnectionPool Defines parameters for http connection pooling
 * @property httpRetryPolicy Policy that defines http request retry conditions
 * @property name Name of the resiliency policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tcpConnectionPool Defines parameters for tcp connection pooling
 * @property tcpRetryPolicy Policy that defines tcp request retry conditions
 * @property timeoutPolicy Policy to set request timeouts
 */
public data class AppResiliencyArgs(
    public val appName: Output<String>? = null,
    public val circuitBreakerPolicy: Output<CircuitBreakerPolicyArgs>? = null,
    public val httpConnectionPool: Output<HttpConnectionPoolArgs>? = null,
    public val httpRetryPolicy: Output<HttpRetryPolicyArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tcpConnectionPool: Output<TcpConnectionPoolArgs>? = null,
    public val tcpRetryPolicy: Output<TcpRetryPolicyArgs>? = null,
    public val timeoutPolicy: Output<TimeoutPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.AppResiliencyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.AppResiliencyArgs =
        com.pulumi.azurenative.app.AppResiliencyArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .circuitBreakerPolicy(
                circuitBreakerPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpConnectionPool(
                httpConnectionPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpRetryPolicy(httpRetryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tcpConnectionPool(tcpConnectionPool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tcpRetryPolicy(tcpRetryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutPolicy(timeoutPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AppResiliencyArgs].
 */
@PulumiTagMarker
public class AppResiliencyArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var circuitBreakerPolicy: Output<CircuitBreakerPolicyArgs>? = null

    private var httpConnectionPool: Output<HttpConnectionPoolArgs>? = null

    private var httpRetryPolicy: Output<HttpRetryPolicyArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tcpConnectionPool: Output<TcpConnectionPoolArgs>? = null

    private var tcpRetryPolicy: Output<TcpRetryPolicyArgs>? = null

    private var timeoutPolicy: Output<TimeoutPolicyArgs>? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("fcqaxawcgxxikfmp")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value Policy that defines circuit breaker conditions
     */
    @JvmName("gjnklplrxqrhbmuf")
    public suspend fun circuitBreakerPolicy(`value`: Output<CircuitBreakerPolicyArgs>) {
        this.circuitBreakerPolicy = value
    }

    /**
     * @param value Defines parameters for http connection pooling
     */
    @JvmName("eccjpytnpnaomuhw")
    public suspend fun httpConnectionPool(`value`: Output<HttpConnectionPoolArgs>) {
        this.httpConnectionPool = value
    }

    /**
     * @param value Policy that defines http request retry conditions
     */
    @JvmName("biqbgkgdctlbkkou")
    public suspend fun httpRetryPolicy(`value`: Output<HttpRetryPolicyArgs>) {
        this.httpRetryPolicy = value
    }

    /**
     * @param value Name of the resiliency policy.
     */
    @JvmName("ljecnbdwfnubgdls")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cbolysaahgnivldg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Defines parameters for tcp connection pooling
     */
    @JvmName("fstktyhvxmgqqlnj")
    public suspend fun tcpConnectionPool(`value`: Output<TcpConnectionPoolArgs>) {
        this.tcpConnectionPool = value
    }

    /**
     * @param value Policy that defines tcp request retry conditions
     */
    @JvmName("ampskxylrkpqecji")
    public suspend fun tcpRetryPolicy(`value`: Output<TcpRetryPolicyArgs>) {
        this.tcpRetryPolicy = value
    }

    /**
     * @param value Policy to set request timeouts
     */
    @JvmName("nkwgenqimxpthcxu")
    public suspend fun timeoutPolicy(`value`: Output<TimeoutPolicyArgs>) {
        this.timeoutPolicy = value
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("ilgtkdbrxcfosmly")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value Policy that defines circuit breaker conditions
     */
    @JvmName("xagfxdmtoapmtpsx")
    public suspend fun circuitBreakerPolicy(`value`: CircuitBreakerPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.circuitBreakerPolicy = mapped
    }

    /**
     * @param argument Policy that defines circuit breaker conditions
     */
    @JvmName("cbjsldbhhpdrohjt")
    public suspend
    fun circuitBreakerPolicy(argument: suspend CircuitBreakerPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = CircuitBreakerPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.circuitBreakerPolicy = mapped
    }

    /**
     * @param value Defines parameters for http connection pooling
     */
    @JvmName("fvyolammiurlvddx")
    public suspend fun httpConnectionPool(`value`: HttpConnectionPoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpConnectionPool = mapped
    }

    /**
     * @param argument Defines parameters for http connection pooling
     */
    @JvmName("wbwrmqienjuluvyt")
    public suspend
    fun httpConnectionPool(argument: suspend HttpConnectionPoolArgsBuilder.() -> Unit) {
        val toBeMapped = HttpConnectionPoolArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpConnectionPool = mapped
    }

    /**
     * @param value Policy that defines http request retry conditions
     */
    @JvmName("uhbhxfwgkbprpbqj")
    public suspend fun httpRetryPolicy(`value`: HttpRetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRetryPolicy = mapped
    }

    /**
     * @param argument Policy that defines http request retry conditions
     */
    @JvmName("wnxuvhmxlimmpqrc")
    public suspend fun httpRetryPolicy(argument: suspend HttpRetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = HttpRetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpRetryPolicy = mapped
    }

    /**
     * @param value Name of the resiliency policy.
     */
    @JvmName("lvyfvnaohgbqrdfr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eduvrricixxqpcgo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Defines parameters for tcp connection pooling
     */
    @JvmName("urqhwxyksuffuyjd")
    public suspend fun tcpConnectionPool(`value`: TcpConnectionPoolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpConnectionPool = mapped
    }

    /**
     * @param argument Defines parameters for tcp connection pooling
     */
    @JvmName("afkqaehcqksvddbv")
    public suspend fun tcpConnectionPool(argument: suspend TcpConnectionPoolArgsBuilder.() -> Unit) {
        val toBeMapped = TcpConnectionPoolArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcpConnectionPool = mapped
    }

    /**
     * @param value Policy that defines tcp request retry conditions
     */
    @JvmName("meulkknafgukrwxc")
    public suspend fun tcpRetryPolicy(`value`: TcpRetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpRetryPolicy = mapped
    }

    /**
     * @param argument Policy that defines tcp request retry conditions
     */
    @JvmName("inwxryfsjaekpwvm")
    public suspend fun tcpRetryPolicy(argument: suspend TcpRetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = TcpRetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcpRetryPolicy = mapped
    }

    /**
     * @param value Policy to set request timeouts
     */
    @JvmName("kcbbrmntxapamljc")
    public suspend fun timeoutPolicy(`value`: TimeoutPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutPolicy = mapped
    }

    /**
     * @param argument Policy to set request timeouts
     */
    @JvmName("fnyaoxonbapquscq")
    public suspend fun timeoutPolicy(argument: suspend TimeoutPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = TimeoutPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeoutPolicy = mapped
    }

    internal fun build(): AppResiliencyArgs = AppResiliencyArgs(
        appName = appName,
        circuitBreakerPolicy = circuitBreakerPolicy,
        httpConnectionPool = httpConnectionPool,
        httpRetryPolicy = httpRetryPolicy,
        name = name,
        resourceGroupName = resourceGroupName,
        tcpConnectionPool = tcpConnectionPool,
        tcpRetryPolicy = tcpRetryPolicy,
        timeoutPolicy = timeoutPolicy,
    )
}
