@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.BuildArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.BuildConfigurationArgs
import com.pulumi.azurenative.app.kotlin.inputs.BuildConfigurationArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.ContainerRegistryWithCustomImageArgs
import com.pulumi.azurenative.app.kotlin.inputs.ContainerRegistryWithCustomImageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Information pertaining to an individual build.
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Example Usage
 * ### Builds_CreateOrUpdate_NoConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var build = new AzureNative.App.Build("build", new()
 *     {
 *         BuildName = "testBuild",
 *         BuilderName = "testBuilder",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewBuild(ctx, "build", &app.BuildArgs{
 * 			BuildName:         pulumi.String("testBuild"),
 * 			BuilderName:       pulumi.String("testBuilder"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Build;
 * import com.pulumi.azurenative.app.BuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var build = new Build("build", BuildArgs.builder()
 *             .buildName("testBuild")
 *             .builderName("testBuilder")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Builds_CreateOrUpdate_WithConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var build = new AzureNative.App.Build("build", new()
 *     {
 *         BuildName = "testBuild-123456789az",
 *         BuilderName = "testBuilder",
 *         Configuration = new AzureNative.App.Inputs.BuildConfigurationArgs
 *         {
 *             BaseOs = "DebianBullseye",
 *             EnvironmentVariables = new[]
 *             {
 *                 new AzureNative.App.Inputs.EnvironmentVariableArgs
 *                 {
 *                     Name = "foo1",
 *                     Value = "bar1",
 *                 },
 *                 new AzureNative.App.Inputs.EnvironmentVariableArgs
 *                 {
 *                     Name = "foo2",
 *                     Value = "bar2",
 *                 },
 *             },
 *             Platform = "dotnetcore",
 *             PlatformVersion = "7.0",
 *             PreBuildSteps = new[]
 *             {
 *                 new AzureNative.App.Inputs.PreBuildStepArgs
 *                 {
 *                     Description = "First pre build step.",
 *                     HttpGet = new AzureNative.App.Inputs.HttpGetArgs
 *                     {
 *                         FileName = "output.txt",
 *                         Headers = new[]
 *                         {
 *                             "foo",
 *                             "bar",
 *                         },
 *                         Url = "https://microsoft.com",
 *                     },
 *                     Scripts = new[]
 *                     {
 *                         "echo 'hello'",
 *                         "echo 'world'",
 *                     },
 *                 },
 *                 new AzureNative.App.Inputs.PreBuildStepArgs
 *                 {
 *                     Description = "Second pre build step.",
 *                     HttpGet = new AzureNative.App.Inputs.HttpGetArgs
 *                     {
 *                         FileName = "output.txt",
 *                         Headers = new[]
 *                         {
 *                             "foo",
 *                         },
 *                         Url = "https://microsoft.com",
 *                     },
 *                     Scripts = new[]
 *                     {
 *                         "echo 'hello'",
 *                         "echo 'again'",
 *                     },
 *                 },
 *             },
 *         },
 *         DestinationContainerRegistry = new AzureNative.App.Inputs.ContainerRegistryWithCustomImageArgs
 *         {
 *             Image = "test.azurecr.io/repo:tag",
 *             Server = "test.azurecr.io",
 *         },
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewBuild(ctx, "build", &app.BuildArgs{
 * 			BuildName:   pulumi.String("testBuild-123456789az"),
 * 			BuilderName: pulumi.String("testBuilder"),
 * 			Configuration: &app.BuildConfigurationArgs{
 * 				BaseOs: pulumi.String("DebianBullseye"),
 * 				EnvironmentVariables: app.EnvironmentVariableArray{
 * 					&app.EnvironmentVariableArgs{
 * 						Name:  pulumi.String("foo1"),
 * 						Value: pulumi.String("bar1"),
 * 					},
 * 					&app.EnvironmentVariableArgs{
 * 						Name:  pulumi.String("foo2"),
 * 						Value: pulumi.String("bar2"),
 * 					},
 * 				},
 * 				Platform:        pulumi.String("dotnetcore"),
 * 				PlatformVersion: pulumi.String("7.0"),
 * 				PreBuildSteps: app.PreBuildStepArray{
 * 					&app.PreBuildStepArgs{
 * 						Description: pulumi.String("First pre build step."),
 * 						HttpGet: &app.HttpGetArgs{
 * 							FileName: pulumi.String("output.txt"),
 * 							Headers: pulumi.StringArray{
 * 								pulumi.String("foo"),
 * 								pulumi.String("bar"),
 * 							},
 * 							Url: pulumi.String("https://microsoft.com"),
 * 						},
 * 						Scripts: pulumi.StringArray{
 * 							pulumi.String("echo 'hello'"),
 * 							pulumi.String("echo 'world'"),
 * 						},
 * 					},
 * 					&app.PreBuildStepArgs{
 * 						Description: pulumi.String("Second pre build step."),
 * 						HttpGet: &app.HttpGetArgs{
 * 							FileName: pulumi.String("output.txt"),
 * 							Headers: pulumi.StringArray{
 * 								pulumi.String("foo"),
 * 							},
 * 							Url: pulumi.String("https://microsoft.com"),
 * 						},
 * 						Scripts: pulumi.StringArray{
 * 							pulumi.String("echo 'hello'"),
 * 							pulumi.String("echo 'again'"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			DestinationContainerRegistry: &app.ContainerRegistryWithCustomImageArgs{
 * 				Image:  pulumi.String("test.azurecr.io/repo:tag"),
 * 				Server: pulumi.String("test.azurecr.io"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Build;
 * import com.pulumi.azurenative.app.BuildArgs;
 * import com.pulumi.azurenative.app.inputs.BuildConfigurationArgs;
 * import com.pulumi.azurenative.app.inputs.ContainerRegistryWithCustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var build = new Build("build", BuildArgs.builder()
 *             .buildName("testBuild-123456789az")
 *             .builderName("testBuilder")
 *             .configuration(BuildConfigurationArgs.builder()
 *                 .baseOs("DebianBullseye")
 *                 .environmentVariables(
 *                     EnvironmentVariableArgs.builder()
 *                         .name("foo1")
 *                         .value("bar1")
 *                         .build(),
 *                     EnvironmentVariableArgs.builder()
 *                         .name("foo2")
 *                         .value("bar2")
 *                         .build())
 *                 .platform("dotnetcore")
 *                 .platformVersion("7.0")
 *                 .preBuildSteps(
 *                     PreBuildStepArgs.builder()
 *                         .description("First pre build step.")
 *                         .httpGet(HttpGetArgs.builder()
 *                             .fileName("output.txt")
 *                             .headers(
 *                                 "foo",
 *                                 "bar")
 *                             .url("https://microsoft.com")
 *                             .build())
 *                         .scripts(
 *                             "echo 'hello'",
 *                             "echo 'world'")
 *                         .build(),
 *                     PreBuildStepArgs.builder()
 *                         .description("Second pre build step.")
 *                         .httpGet(HttpGetArgs.builder()
 *                             .fileName("output.txt")
 *                             .headers("foo")
 *                             .url("https://microsoft.com")
 *                             .build())
 *                         .scripts(
 *                             "echo 'hello'",
 *                             "echo 'again'")
 *                         .build())
 *                 .build())
 *             .destinationContainerRegistry(ContainerRegistryWithCustomImageArgs.builder()
 *                 .image("test.azurecr.io/repo:tag")
 *                 .server("test.azurecr.io")
 *                 .build())
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Build testBuild-123456789az /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/builders/{builderName}/builds/{buildName}
 * ```
 * @property buildName The name of a build.
 * @property builderName The name of the builder.
 * @property configuration Configuration of the build.
 * @property destinationContainerRegistry Container registry that the final image will be uploaded to.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class BuildArgs(
    public val buildName: Output<String>? = null,
    public val builderName: Output<String>? = null,
    public val configuration: Output<BuildConfigurationArgs>? = null,
    public val destinationContainerRegistry: Output<ContainerRegistryWithCustomImageArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.BuildArgs> {
    override fun toJava(): com.pulumi.azurenative.app.BuildArgs =
        com.pulumi.azurenative.app.BuildArgs.builder()
            .buildName(buildName?.applyValue({ args0 -> args0 }))
            .builderName(builderName?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .destinationContainerRegistry(
                destinationContainerRegistry?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildArgs].
 */
@PulumiTagMarker
public class BuildArgsBuilder internal constructor() {
    private var buildName: Output<String>? = null

    private var builderName: Output<String>? = null

    private var configuration: Output<BuildConfigurationArgs>? = null

    private var destinationContainerRegistry: Output<ContainerRegistryWithCustomImageArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of a build.
     */
    @JvmName("feavpisbniqaceke")
    public suspend fun buildName(`value`: Output<String>) {
        this.buildName = value
    }

    /**
     * @param value The name of the builder.
     */
    @JvmName("hckdcwkfmgewhkvu")
    public suspend fun builderName(`value`: Output<String>) {
        this.builderName = value
    }

    /**
     * @param value Configuration of the build.
     */
    @JvmName("hrsrvfrntuxbkyln")
    public suspend fun configuration(`value`: Output<BuildConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Container registry that the final image will be uploaded to.
     */
    @JvmName("cvfbjfnfyefdqyek")
    public suspend
    fun destinationContainerRegistry(`value`: Output<ContainerRegistryWithCustomImageArgs>) {
        this.destinationContainerRegistry = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fxonhmxjimexcchr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of a build.
     */
    @JvmName("qfjxegknyvsrfgew")
    public suspend fun buildName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildName = mapped
    }

    /**
     * @param value The name of the builder.
     */
    @JvmName("ewhpwoqjgxmkeucp")
    public suspend fun builderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builderName = mapped
    }

    /**
     * @param value Configuration of the build.
     */
    @JvmName("ucvsdjjhpjvgbapj")
    public suspend fun configuration(`value`: BuildConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration of the build.
     */
    @JvmName("hrtfreyhuopjlapy")
    public suspend fun configuration(argument: suspend BuildConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BuildConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Container registry that the final image will be uploaded to.
     */
    @JvmName("tnmituefilfupvni")
    public suspend fun destinationContainerRegistry(`value`: ContainerRegistryWithCustomImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationContainerRegistry = mapped
    }

    /**
     * @param argument Container registry that the final image will be uploaded to.
     */
    @JvmName("hsgaxwqfjwjburqf")
    public suspend
    fun destinationContainerRegistry(argument: suspend ContainerRegistryWithCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRegistryWithCustomImageArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationContainerRegistry = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("srmflnkgqgcyvhfj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): BuildArgs = BuildArgs(
        buildName = buildName,
        builderName = builderName,
        configuration = configuration,
        destinationContainerRegistry = destinationContainerRegistry,
        resourceGroupName = resourceGroupName,
    )
}
