@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.CertificateArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.CertificatePropertiesArgs
import com.pulumi.azurenative.app.kotlin.inputs.CertificatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.App.Certificate("certificate", new()
 *     {
 *         CertificateName = "certificate-firendly-name",
 *         EnvironmentName = "testcontainerenv",
 *         Location = "East US",
 *         Properties = new AzureNative.App.Inputs.CertificatePropertiesArgs
 *         {
 *             Password = "private key password",
 *             Value = "Y2VydA==",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewCertificate(ctx, "certificate", &app.CertificateArgs{
 * 			CertificateName: pulumi.String("certificate-firendly-name"),
 * 			EnvironmentName: pulumi.String("testcontainerenv"),
 * 			Location:        pulumi.String("East US"),
 * 			Properties: &app.CertificatePropertiesArgs{
 * 				Password: pulumi.String("private key password"),
 * 				Value:    pulumi.String("Y2VydA=="),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Certificate;
 * import com.pulumi.azurenative.app.CertificateArgs;
 * import com.pulumi.azurenative.app.inputs.CertificatePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateName("certificate-firendly-name")
 *             .environmentName("testcontainerenv")
 *             .location("East US")
 *             .properties(CertificatePropertiesArgs.builder()
 *                 .password("private key password")
 *                 .value("Y2VydA==")
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Certificate myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/certificates/{certificateName}
 * ```
 * @property certificateName Name of the Certificate.
 * @property environmentName Name of the Managed Environment.
 * @property location The geo-location where the resource lives
 * @property properties Certificate resource specific properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class CertificateArgs(
    public val certificateName: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<CertificatePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.app.CertificateArgs =
        com.pulumi.azurenative.app.CertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<CertificatePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Certificate.
     */
    @JvmName("vwvtobahnhxkjifa")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("qppovasdnqfrsyib")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("runjlyvgdtaspvmw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Certificate resource specific properties
     */
    @JvmName("yvcocjxnekphsmmd")
    public suspend fun properties(`value`: Output<CertificatePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hdrqslnxbyavvyws")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tpemecenuitwbggk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Certificate.
     */
    @JvmName("edjqxlidnvqcnqqj")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("vjklidoqfvisshej")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("syvuyeyojctlktir")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Certificate resource specific properties
     */
    @JvmName("eutjwghaadefkduu")
    public suspend fun properties(`value`: CertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Certificate resource specific properties
     */
    @JvmName("fnhmrpahlsaocrng")
    public suspend fun properties(argument: suspend CertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xpbcaubgvtluhiiv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oodjrbmtwbvidyfk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tmwdpwtrqqgvwnyf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificateName = certificateName,
        environmentName = environmentName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
