@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.DaprMetadataResponse
import com.pulumi.azurenative.app.kotlin.outputs.SecretResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.app.kotlin.outputs.DaprMetadataResponse.Companion.toKotlin as daprMetadataResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SecretResponse.Companion.toKotlin as secretResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConnectedEnvironmentsDaprComponent].
 */
@PulumiTagMarker
public class ConnectedEnvironmentsDaprComponentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectedEnvironmentsDaprComponentArgs = ConnectedEnvironmentsDaprComponentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectedEnvironmentsDaprComponentArgsBuilder.() -> Unit) {
        val builder = ConnectedEnvironmentsDaprComponentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectedEnvironmentsDaprComponent {
        val builtJavaResource =
            com.pulumi.azurenative.app.ConnectedEnvironmentsDaprComponent(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectedEnvironmentsDaprComponent(builtJavaResource)
    }
}

/**
 * Dapr Component.
 * Azure REST API version: 2022-10-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create or update dapr component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedEnvironmentsDaprComponent = new AzureNative.App.ConnectedEnvironmentsDaprComponent("connectedEnvironmentsDaprComponent", new()
 *     {
 *         ComponentName = "reddog",
 *         ComponentType = "state.azure.cosmosdb",
 *         ConnectedEnvironmentName = "myenvironment",
 *         IgnoreErrors = false,
 *         InitTimeout = "50s",
 *         Metadata = new[]
 *         {
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "url",
 *                 Value = "<COSMOS-URL>",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "database",
 *                 Value = "itemsDB",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "collection",
 *                 Value = "items",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "masterkey",
 *                 SecretRef = "masterkey",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         Scopes = new[]
 *         {
 *             "container-app-1",
 *             "container-app-2",
 *         },
 *         Secrets = new[]
 *         {
 *             new AzureNative.App.Inputs.SecretArgs
 *             {
 *                 Name = "masterkey",
 *                 Value = "keyvalue",
 *             },
 *         },
 *         Version = "v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewConnectedEnvironmentsDaprComponent(ctx, "connectedEnvironmentsDaprComponent", &app.ConnectedEnvironmentsDaprComponentArgs{
 * 			ComponentName:            pulumi.String("reddog"),
 * 			ComponentType:            pulumi.String("state.azure.cosmosdb"),
 * 			ConnectedEnvironmentName: pulumi.String("myenvironment"),
 * 			IgnoreErrors:             pulumi.Bool(false),
 * 			InitTimeout:              pulumi.String("50s"),
 * 			Metadata: app.DaprMetadataArray{
 * 				&app.DaprMetadataArgs{
 * 					Name:  pulumi.String("url"),
 * 					Value: pulumi.String("<COSMOS-URL>"),
 * 				},
 * 				&app.DaprMetadataArgs{
 * 					Name:  pulumi.String("database"),
 * 					Value: pulumi.String("itemsDB"),
 * 				},
 * 				&app.DaprMetadataArgs{
 * 					Name:  pulumi.String("collection"),
 * 					Value: pulumi.String("items"),
 * 				},
 * 				&app.DaprMetadataArgs{
 * 					Name:      pulumi.String("masterkey"),
 * 					SecretRef: pulumi.String("masterkey"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("container-app-1"),
 * 				pulumi.String("container-app-2"),
 * 			},
 * 			Secrets: app.SecretArray{
 * 				&app.SecretArgs{
 * 					Name:  pulumi.String("masterkey"),
 * 					Value: pulumi.String("keyvalue"),
 * 				},
 * 			},
 * 			Version: pulumi.String("v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentsDaprComponent;
 * import com.pulumi.azurenative.app.ConnectedEnvironmentsDaprComponentArgs;
 * import com.pulumi.azurenative.app.inputs.DaprMetadataArgs;
 * import com.pulumi.azurenative.app.inputs.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedEnvironmentsDaprComponent = new ConnectedEnvironmentsDaprComponent("connectedEnvironmentsDaprComponent", ConnectedEnvironmentsDaprComponentArgs.builder()
 *             .componentName("reddog")
 *             .componentType("state.azure.cosmosdb")
 *             .connectedEnvironmentName("myenvironment")
 *             .ignoreErrors(false)
 *             .initTimeout("50s")
 *             .metadata(
 *                 DaprMetadataArgs.builder()
 *                     .name("url")
 *                     .value("<COSMOS-URL>")
 *                     .build(),
 *                 DaprMetadataArgs.builder()
 *                     .name("database")
 *                     .value("itemsDB")
 *                     .build(),
 *                 DaprMetadataArgs.builder()
 *                     .name("collection")
 *                     .value("items")
 *                     .build(),
 *                 DaprMetadataArgs.builder()
 *                     .name("masterkey")
 *                     .secretRef("masterkey")
 *                     .build())
 *             .resourceGroupName("examplerg")
 *             .scopes(
 *                 "container-app-1",
 *                 "container-app-2")
 *             .secrets(SecretArgs.builder()
 *                 .name("masterkey")
 *                 .value("keyvalue")
 *                 .build())
 *             .version("v1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ConnectedEnvironmentsDaprComponent reddog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/daprComponents/{componentName}
 * ```
 */
public class ConnectedEnvironmentsDaprComponent internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ConnectedEnvironmentsDaprComponent,
) : KotlinCustomResource(javaResource, ConnectedEnvironmentsDaprComponentMapper) {
    /**
     * Component type
     */
    public val componentType: Output<String>?
        get() = javaResource.componentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean describing if the component errors are ignores
     */
    public val ignoreErrors: Output<Boolean>?
        get() = javaResource.ignoreErrors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Initialization timeout
     */
    public val initTimeout: Output<String>?
        get() = javaResource.initTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Component metadata
     */
    public val metadata: Output<List<DaprMetadataResponse>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> daprMetadataResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Names of container apps that can use this Dapr component
     */
    public val scopes: Output<List<String>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of a Dapr component to retrieve component secrets from
     */
    public val secretStoreComponent: Output<String>?
        get() = javaResource.secretStoreComponent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collection of secrets used by a Dapr component
     */
    public val secrets: Output<List<SecretResponse>>?
        get() = javaResource.secrets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> secretResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Component version
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ConnectedEnvironmentsDaprComponentMapper :
    ResourceMapper<ConnectedEnvironmentsDaprComponent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ConnectedEnvironmentsDaprComponent::class == javaResource::class

    override fun map(javaResource: Resource): ConnectedEnvironmentsDaprComponent =
        ConnectedEnvironmentsDaprComponent(
            javaResource as
                com.pulumi.azurenative.app.ConnectedEnvironmentsDaprComponent,
        )
}

/**
 * @see [ConnectedEnvironmentsDaprComponent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectedEnvironmentsDaprComponent].
 */
public suspend fun connectedEnvironmentsDaprComponent(
    name: String,
    block: suspend ConnectedEnvironmentsDaprComponentResourceBuilder.() -> Unit,
):
    ConnectedEnvironmentsDaprComponent {
    val builder = ConnectedEnvironmentsDaprComponentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectedEnvironmentsDaprComponent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectedEnvironmentsDaprComponent(name: String): ConnectedEnvironmentsDaprComponent {
    val builder = ConnectedEnvironmentsDaprComponentResourceBuilder()
    builder.name(name)
    return builder.build()
}
