@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionBulkSubscribeOptionsResponse
import com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionRoutesResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionBulkSubscribeOptionsResponse.Companion.toKotlin as daprSubscriptionBulkSubscribeOptionsResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionRoutesResponse.Companion.toKotlin as daprSubscriptionRoutesResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DaprSubscription].
 */
@PulumiTagMarker
public class DaprSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DaprSubscriptionArgs = DaprSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DaprSubscriptionArgsBuilder.() -> Unit) {
        val builder = DaprSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DaprSubscription {
        val builtJavaResource = com.pulumi.azurenative.app.DaprSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DaprSubscription(builtJavaResource)
    }
}

/**
 * Dapr PubSub Event Subscription.
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or update dapr subscription with bulk subscribe configuration and scopes
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprSubscription = new AzureNative.App.DaprSubscription("daprSubscription", new()
 *     {
 *         BulkSubscribe = new AzureNative.App.Inputs.DaprSubscriptionBulkSubscribeOptionsArgs
 *         {
 *             Enabled = true,
 *             MaxAwaitDurationMs = 500,
 *             MaxMessagesCount = 123,
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "mysubscription",
 *         PubsubName = "mypubsubcomponent",
 *         ResourceGroupName = "examplerg",
 *         Routes = new AzureNative.App.Inputs.DaprSubscriptionRoutesArgs
 *         {
 *             Default = "/products",
 *         },
 *         Scopes = new[]
 *         {
 *             "warehouseapp",
 *             "customersupportapp",
 *         },
 *         Topic = "inventory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprSubscription(ctx, "daprSubscription", &app.DaprSubscriptionArgs{
 * 			BulkSubscribe: &app.DaprSubscriptionBulkSubscribeOptionsArgs{
 * 				Enabled:            pulumi.Bool(true),
 * 				MaxAwaitDurationMs: pulumi.Int(500),
 * 				MaxMessagesCount:   pulumi.Int(123),
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mysubscription"),
 * 			PubsubName:        pulumi.String("mypubsubcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Routes: &app.DaprSubscriptionRoutesArgs{
 * 				Default: pulumi.String("/products"),
 * 			},
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("warehouseapp"),
 * 				pulumi.String("customersupportapp"),
 * 			},
 * 			Topic: pulumi.String("inventory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprSubscription;
 * import com.pulumi.azurenative.app.DaprSubscriptionArgs;
 * import com.pulumi.azurenative.app.inputs.DaprSubscriptionBulkSubscribeOptionsArgs;
 * import com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprSubscription = new DaprSubscription("daprSubscription", DaprSubscriptionArgs.builder()
 *             .bulkSubscribe(DaprSubscriptionBulkSubscribeOptionsArgs.builder()
 *                 .enabled(true)
 *                 .maxAwaitDurationMs(500)
 *                 .maxMessagesCount(123)
 *                 .build())
 *             .environmentName("myenvironment")
 *             .name("mysubscription")
 *             .pubsubName("mypubsubcomponent")
 *             .resourceGroupName("examplerg")
 *             .routes(DaprSubscriptionRoutesArgs.builder()
 *                 .default_("/products")
 *                 .build())
 *             .scopes(
 *                 "warehouseapp",
 *                 "customersupportapp")
 *             .topic("inventory")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr subscription with default route only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprSubscription = new AzureNative.App.DaprSubscription("daprSubscription", new()
 *     {
 *         EnvironmentName = "myenvironment",
 *         Name = "mysubscription",
 *         PubsubName = "mypubsubcomponent",
 *         ResourceGroupName = "examplerg",
 *         Routes = new AzureNative.App.Inputs.DaprSubscriptionRoutesArgs
 *         {
 *             Default = "/products",
 *         },
 *         Topic = "inventory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprSubscription(ctx, "daprSubscription", &app.DaprSubscriptionArgs{
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("mysubscription"),
 * 			PubsubName:        pulumi.String("mypubsubcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Routes: &app.DaprSubscriptionRoutesArgs{
 * 				Default: pulumi.String("/products"),
 * 			},
 * 			Topic: pulumi.String("inventory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprSubscription;
 * import com.pulumi.azurenative.app.DaprSubscriptionArgs;
 * import com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprSubscription = new DaprSubscription("daprSubscription", DaprSubscriptionArgs.builder()
 *             .environmentName("myenvironment")
 *             .name("mysubscription")
 *             .pubsubName("mypubsubcomponent")
 *             .resourceGroupName("examplerg")
 *             .routes(DaprSubscriptionRoutesArgs.builder()
 *                 .default_("/products")
 *                 .build())
 *             .topic("inventory")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr subscription with route rules and metadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprSubscription = new AzureNative.App.DaprSubscription("daprSubscription", new()
 *     {
 *         EnvironmentName = "myenvironment",
 *         Metadata =
 *         {
 *             { "foo", "bar" },
 *             { "hello", "world" },
 *         },
 *         Name = "mysubscription",
 *         PubsubName = "mypubsubcomponent",
 *         ResourceGroupName = "examplerg",
 *         Routes = new AzureNative.App.Inputs.DaprSubscriptionRoutesArgs
 *         {
 *             Default = "/products",
 *             Rules = new[]
 *             {
 *                 new AzureNative.App.Inputs.DaprSubscriptionRouteRuleArgs
 *                 {
 *                     Match = "event.type == 'widget'",
 *                     Path = "/widgets",
 *                 },
 *                 new AzureNative.App.Inputs.DaprSubscriptionRouteRuleArgs
 *                 {
 *                     Match = "event.type == 'gadget'",
 *                     Path = "/gadgets",
 *                 },
 *             },
 *         },
 *         Topic = "inventory",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprSubscription(ctx, "daprSubscription", &app.DaprSubscriptionArgs{
 * 			EnvironmentName: pulumi.String("myenvironment"),
 * 			Metadata: pulumi.StringMap{
 * 				"foo":   pulumi.String("bar"),
 * 				"hello": pulumi.String("world"),
 * 			},
 * 			Name:              pulumi.String("mysubscription"),
 * 			PubsubName:        pulumi.String("mypubsubcomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Routes: &app.DaprSubscriptionRoutesArgs{
 * 				Default: pulumi.String("/products"),
 * 				Rules: app.DaprSubscriptionRouteRuleArray{
 * 					&app.DaprSubscriptionRouteRuleArgs{
 * 						Match: pulumi.String("event.type == 'widget'"),
 * 						Path:  pulumi.String("/widgets"),
 * 					},
 * 					&app.DaprSubscriptionRouteRuleArgs{
 * 						Match: pulumi.String("event.type == 'gadget'"),
 * 						Path:  pulumi.String("/gadgets"),
 * 					},
 * 				},
 * 			},
 * 			Topic: pulumi.String("inventory"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprSubscription;
 * import com.pulumi.azurenative.app.DaprSubscriptionArgs;
 * import com.pulumi.azurenative.app.inputs.DaprSubscriptionRoutesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprSubscription = new DaprSubscription("daprSubscription", DaprSubscriptionArgs.builder()
 *             .environmentName("myenvironment")
 *             .metadata(Map.ofEntries(
 *                 Map.entry("foo", "bar"),
 *                 Map.entry("hello", "world")
 *             ))
 *             .name("mysubscription")
 *             .pubsubName("mypubsubcomponent")
 *             .resourceGroupName("examplerg")
 *             .routes(DaprSubscriptionRoutesArgs.builder()
 *                 .default_("/products")
 *                 .rules(
 *                     DaprSubscriptionRouteRuleArgs.builder()
 *                         .match("event.type == 'widget'")
 *                         .path("/widgets")
 *                         .build(),
 *                     DaprSubscriptionRouteRuleArgs.builder()
 *                         .match("event.type == 'gadget'")
 *                         .path("/gadgets")
 *                         .build())
 *                 .build())
 *             .topic("inventory")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DaprSubscription mysubscription /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/daprSubscriptions/{name}
 * ```
 */
public class DaprSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.app.DaprSubscription,
) : KotlinCustomResource(javaResource, DaprSubscriptionMapper) {
    /**
     * Bulk subscription options
     */
    public val bulkSubscribe: Output<DaprSubscriptionBulkSubscribeOptionsResponse>?
        get() = javaResource.bulkSubscribe().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    daprSubscriptionBulkSubscribeOptionsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Deadletter topic name
     */
    public val deadLetterTopic: Output<String>?
        get() = javaResource.deadLetterTopic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subscription metadata
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dapr PubSub component name
     */
    public val pubsubName: Output<String>?
        get() = javaResource.pubsubName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subscription routes
     */
    public val routes: Output<DaprSubscriptionRoutesResponse>?
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    daprSubscriptionRoutesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Application scopes to restrict the subscription to specific apps.
     */
    public val scopes: Output<List<String>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Topic name
     */
    public val topic: Output<String>?
        get() = javaResource.topic().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DaprSubscriptionMapper : ResourceMapper<DaprSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.DaprSubscription::class == javaResource::class

    override fun map(javaResource: Resource): DaprSubscription = DaprSubscription(
        javaResource as
            com.pulumi.azurenative.app.DaprSubscription,
    )
}

/**
 * @see [DaprSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DaprSubscription].
 */
public suspend fun daprSubscription(
    name: String,
    block: suspend DaprSubscriptionResourceBuilder.() -> Unit,
): DaprSubscription {
    val builder = DaprSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DaprSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun daprSubscription(name: String): DaprSubscription {
    val builder = DaprSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
