@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.JavaComponentArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.JavaComponentType
import com.pulumi.azurenative.app.kotlin.inputs.JavaComponentConfigurationPropertyArgs
import com.pulumi.azurenative.app.kotlin.inputs.JavaComponentConfigurationPropertyArgsBuilder
import com.pulumi.azurenative.app.kotlin.inputs.JavaComponentServiceBindArgs
import com.pulumi.azurenative.app.kotlin.inputs.JavaComponentServiceBindArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Java Component.
 * Azure REST API version: 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update Java Component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var javaComponent = new AzureNative.App.JavaComponent("javaComponent", new()
 *     {
 *         ComponentType = AzureNative.App.JavaComponentType.SpringBootAdmin,
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.ui.enable-toasts",
 *                 Value = "true",
 *             },
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.monitor.status-interval",
 *                 Value = "10000ms",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "myjavacomponent",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewJavaComponent(ctx, "javaComponent", &app.JavaComponentArgs{
 * 			ComponentType: pulumi.String(app.JavaComponentTypeSpringBootAdmin),
 * 			Configurations: app.JavaComponentConfigurationPropertyArray{
 * 				&app.JavaComponentConfigurationPropertyArgs{
 * 					PropertyName: pulumi.String("spring.boot.admin.ui.enable-toasts"),
 * 					Value:        pulumi.String("true"),
 * 				},
 * 				&app.JavaComponentConfigurationPropertyArgs{
 * 					PropertyName: pulumi.String("spring.boot.admin.monitor.status-interval"),
 * 					Value:        pulumi.String("10000ms"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("myjavacomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.JavaComponent;
 * import com.pulumi.azurenative.app.JavaComponentArgs;
 * import com.pulumi.azurenative.app.inputs.JavaComponentConfigurationPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var javaComponent = new JavaComponent("javaComponent", JavaComponentArgs.builder()
 *             .componentType("SpringBootAdmin")
 *             .configurations(
 *                 JavaComponentConfigurationPropertyArgs.builder()
 *                     .propertyName("spring.boot.admin.ui.enable-toasts")
 *                     .value("true")
 *                     .build(),
 *                 JavaComponentConfigurationPropertyArgs.builder()
 *                     .propertyName("spring.boot.admin.monitor.status-interval")
 *                     .value("10000ms")
 *                     .build())
 *             .environmentName("myenvironment")
 *             .name("myjavacomponent")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Java Component with ServiceBinds
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var javaComponent = new AzureNative.App.JavaComponent("javaComponent", new()
 *     {
 *         ComponentType = AzureNative.App.JavaComponentType.SpringBootAdmin,
 *         Configurations = new[]
 *         {
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.ui.enable-toasts",
 *                 Value = "true",
 *             },
 *             new AzureNative.App.Inputs.JavaComponentConfigurationPropertyArgs
 *             {
 *                 PropertyName = "spring.boot.admin.monitor.status-interval",
 *                 Value = "10000ms",
 *             },
 *         },
 *         EnvironmentName = "myenvironment",
 *         Name = "myjavacomponent",
 *         ResourceGroupName = "examplerg",
 *         ServiceBinds = new[]
 *         {
 *             new AzureNative.App.Inputs.JavaComponentServiceBindArgs
 *             {
 *                 Name = "yellowcat",
 *                 ServiceId = "/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/javaComponents/yellowcat",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewJavaComponent(ctx, "javaComponent", &app.JavaComponentArgs{
 * 			ComponentType: pulumi.String(app.JavaComponentTypeSpringBootAdmin),
 * 			Configurations: app.JavaComponentConfigurationPropertyArray{
 * 				&app.JavaComponentConfigurationPropertyArgs{
 * 					PropertyName: pulumi.String("spring.boot.admin.ui.enable-toasts"),
 * 					Value:        pulumi.String("true"),
 * 				},
 * 				&app.JavaComponentConfigurationPropertyArgs{
 * 					PropertyName: pulumi.String("spring.boot.admin.monitor.status-interval"),
 * 					Value:        pulumi.String("10000ms"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("myenvironment"),
 * 			Name:              pulumi.String("myjavacomponent"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			ServiceBinds: app.JavaComponentServiceBindArray{
 * 				&app.JavaComponentServiceBindArgs{
 * 					Name:      pulumi.String("yellowcat"),
 * 					ServiceId: pulumi.String("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/javaComponents/yellowcat"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.JavaComponent;
 * import com.pulumi.azurenative.app.JavaComponentArgs;
 * import com.pulumi.azurenative.app.inputs.JavaComponentConfigurationPropertyArgs;
 * import com.pulumi.azurenative.app.inputs.JavaComponentServiceBindArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var javaComponent = new JavaComponent("javaComponent", JavaComponentArgs.builder()
 *             .componentType("SpringBootAdmin")
 *             .configurations(
 *                 JavaComponentConfigurationPropertyArgs.builder()
 *                     .propertyName("spring.boot.admin.ui.enable-toasts")
 *                     .value("true")
 *                     .build(),
 *                 JavaComponentConfigurationPropertyArgs.builder()
 *                     .propertyName("spring.boot.admin.monitor.status-interval")
 *                     .value("10000ms")
 *                     .build())
 *             .environmentName("myenvironment")
 *             .name("myjavacomponent")
 *             .resourceGroupName("examplerg")
 *             .serviceBinds(JavaComponentServiceBindArgs.builder()
 *                 .name("yellowcat")
 *                 .serviceId("/subscriptions/8efdecc5-919e-44eb-b179-915dca89ebf9/resourceGroups/examplerg/providers/Microsoft.App/managedEnvironments/myenvironment/javaComponents/yellowcat")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:JavaComponent myjavacomponent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/javaComponents/{name}
 * ```
 * @property componentType Type of the Java Component.
 * @property configurations List of Java Components configuration properties
 * @property environmentName Name of the Managed Environment.
 * @property name Name of the Java Component.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceBinds List of Java Components that are bound to the Java component
 */
public data class JavaComponentArgs(
    public val componentType: Output<Either<String, JavaComponentType>>? = null,
    public val configurations: Output<List<JavaComponentConfigurationPropertyArgs>>? = null,
    public val environmentName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceBinds: Output<List<JavaComponentServiceBindArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.JavaComponentArgs> {
    override fun toJava(): com.pulumi.azurenative.app.JavaComponentArgs =
        com.pulumi.azurenative.app.JavaComponentArgs.builder()
            .componentType(
                componentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceBinds(
                serviceBinds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JavaComponentArgs].
 */
@PulumiTagMarker
public class JavaComponentArgsBuilder internal constructor() {
    private var componentType: Output<Either<String, JavaComponentType>>? = null

    private var configurations: Output<List<JavaComponentConfigurationPropertyArgs>>? = null

    private var environmentName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceBinds: Output<List<JavaComponentServiceBindArgs>>? = null

    /**
     * @param value Type of the Java Component.
     */
    @JvmName("qcdsrbgjxlqsjuak")
    public suspend fun componentType(`value`: Output<Either<String, JavaComponentType>>) {
        this.componentType = value
    }

    /**
     * @param value List of Java Components configuration properties
     */
    @JvmName("fupkcksjqdnipyjm")
    public suspend fun configurations(`value`: Output<List<JavaComponentConfigurationPropertyArgs>>) {
        this.configurations = value
    }

    @JvmName("rshsbioakssksvhr")
    public suspend fun configurations(vararg values: Output<JavaComponentConfigurationPropertyArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values List of Java Components configuration properties
     */
    @JvmName("rbypbxswcfulhmfc")
    public suspend fun configurations(values: List<Output<JavaComponentConfigurationPropertyArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("ebfpisgioddkilwi")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Name of the Java Component.
     */
    @JvmName("stcqvoujxdkialwn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("axiamlwwcrabclfe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of Java Components that are bound to the Java component
     */
    @JvmName("pncxdakffivardpu")
    public suspend fun serviceBinds(`value`: Output<List<JavaComponentServiceBindArgs>>) {
        this.serviceBinds = value
    }

    @JvmName("wbcfqefvfujqlayu")
    public suspend fun serviceBinds(vararg values: Output<JavaComponentServiceBindArgs>) {
        this.serviceBinds = Output.all(values.asList())
    }

    /**
     * @param values List of Java Components that are bound to the Java component
     */
    @JvmName("hbodxddmpsbufxhk")
    public suspend fun serviceBinds(values: List<Output<JavaComponentServiceBindArgs>>) {
        this.serviceBinds = Output.all(values)
    }

    /**
     * @param value Type of the Java Component.
     */
    @JvmName("xsqnpodavjlcuubv")
    public suspend fun componentType(`value`: Either<String, JavaComponentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Type of the Java Component.
     */
    @JvmName("kbercriogrrrhkmi")
    public fun componentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JavaComponentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value Type of the Java Component.
     */
    @JvmName("ewempuclsogvevmd")
    public fun componentType(`value`: JavaComponentType) {
        val toBeMapped = Either.ofRight<String, JavaComponentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentType = mapped
    }

    /**
     * @param value List of Java Components configuration properties
     */
    @JvmName("cejjykqlojgoaxfp")
    public suspend fun configurations(`value`: List<JavaComponentConfigurationPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument List of Java Components configuration properties
     */
    @JvmName("xfosmomoenpfpyyd")
    public suspend
    fun configurations(argument: List<suspend JavaComponentConfigurationPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JavaComponentConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument List of Java Components configuration properties
     */
    @JvmName("nmptarkwffljqyav")
    public suspend fun configurations(
        vararg
        argument: suspend JavaComponentConfigurationPropertyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JavaComponentConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument List of Java Components configuration properties
     */
    @JvmName("xlbswdxtibodqpei")
    public suspend
    fun configurations(argument: suspend JavaComponentConfigurationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JavaComponentConfigurationPropertyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values List of Java Components configuration properties
     */
    @JvmName("bnyectimwiylyaaq")
    public suspend fun configurations(vararg values: JavaComponentConfigurationPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("kimfxcvrvosodpjc")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the Java Component.
     */
    @JvmName("plhseireqorqvbds")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("syalowgklgkbjudp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of Java Components that are bound to the Java component
     */
    @JvmName("auegtvhjmupfnrbc")
    public suspend fun serviceBinds(`value`: List<JavaComponentServiceBindArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBinds = mapped
    }

    /**
     * @param argument List of Java Components that are bound to the Java component
     */
    @JvmName("sjtrmtvwyldmhxwy")
    public suspend
    fun serviceBinds(argument: List<suspend JavaComponentServiceBindArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JavaComponentServiceBindArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBinds = mapped
    }

    /**
     * @param argument List of Java Components that are bound to the Java component
     */
    @JvmName("cawxvwqpuelinfoa")
    public suspend fun serviceBinds(
        vararg
        argument: suspend JavaComponentServiceBindArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JavaComponentServiceBindArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBinds = mapped
    }

    /**
     * @param argument List of Java Components that are bound to the Java component
     */
    @JvmName("xvkkjujabqeishfk")
    public suspend
    fun serviceBinds(argument: suspend JavaComponentServiceBindArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JavaComponentServiceBindArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceBinds = mapped
    }

    /**
     * @param values List of Java Components that are bound to the Java component
     */
    @JvmName("umekleesonqijfbo")
    public suspend fun serviceBinds(vararg values: JavaComponentServiceBindArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceBinds = mapped
    }

    internal fun build(): JavaComponentArgs = JavaComponentArgs(
        componentType = componentType,
        configurations = configurations,
        environmentName = environmentName,
        name = name,
        resourceGroupName = resourceGroupName,
        serviceBinds = serviceBinds,
    )
}
