@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.ManagedCertificateResponseProperties
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.ManagedCertificateResponseProperties.Companion.toKotlin as managedCertificateResponsePropertiesToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedCertificate].
 */
@PulumiTagMarker
public class ManagedCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedCertificateArgs = ManagedCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedCertificateArgsBuilder.() -> Unit) {
        val builder = ManagedCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedCertificate {
        val builtJavaResource = com.pulumi.azurenative.app.ManagedCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedCertificate(builtJavaResource)
    }
}

/**
 * Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview, 2023-11-02-preview.
 * ## Example Usage
 * ### Create or Update Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCertificate = new AzureNative.App.ManagedCertificate("managedCertificate", new()
 *     {
 *         EnvironmentName = "testcontainerenv",
 *         Location = "East US",
 *         ManagedCertificateName = "certificate-firendly-name",
 *         Properties = new AzureNative.App.Inputs.ManagedCertificatePropertiesArgs
 *         {
 *             DomainControlValidation = AzureNative.App.ManagedCertificateDomainControlValidation.CNAME,
 *             SubjectName = "my-subject-name.company.country.net",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewManagedCertificate(ctx, "managedCertificate", &app.ManagedCertificateArgs{
 * 			EnvironmentName:        pulumi.String("testcontainerenv"),
 * 			Location:               pulumi.String("East US"),
 * 			ManagedCertificateName: pulumi.String("certificate-firendly-name"),
 * 			Properties: &app.ManagedCertificatePropertiesArgs{
 * 				DomainControlValidation: pulumi.String(app.ManagedCertificateDomainControlValidationCNAME),
 * 				SubjectName:             pulumi.String("my-subject-name.company.country.net"),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ManagedCertificate;
 * import com.pulumi.azurenative.app.ManagedCertificateArgs;
 * import com.pulumi.azurenative.app.inputs.ManagedCertificatePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCertificate = new ManagedCertificate("managedCertificate", ManagedCertificateArgs.builder()
 *             .environmentName("testcontainerenv")
 *             .location("East US")
 *             .managedCertificateName("certificate-firendly-name")
 *             .properties(ManagedCertificatePropertiesArgs.builder()
 *                 .domainControlValidation("CNAME")
 *                 .subjectName("my-subject-name.company.country.net")
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ManagedCertificate myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/managedCertificates/{managedCertificateName}
 * ```
 */
public class ManagedCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ManagedCertificate,
) : KotlinCustomResource(javaResource, ManagedCertificateMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Certificate resource specific properties
     */
    public val properties: Output<ManagedCertificateResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                managedCertificateResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedCertificateMapper : ResourceMapper<ManagedCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ManagedCertificate::class == javaResource::class

    override fun map(javaResource: Resource): ManagedCertificate = ManagedCertificate(
        javaResource as
            com.pulumi.azurenative.app.ManagedCertificate,
    )
}

/**
 * @see [ManagedCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedCertificate].
 */
public suspend fun managedCertificate(
    name: String,
    block: suspend ManagedCertificateResourceBuilder.() -> Unit,
): ManagedCertificate {
    val builder = ManagedCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedCertificate(name: String): ManagedCertificate {
    val builder = ManagedCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
