@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
 */
public enum class IngressClientCertificateMode(
    public val javaValue: com.pulumi.azurenative.app.enums.IngressClientCertificateMode,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.IngressClientCertificateMode> {
    Ignore(com.pulumi.azurenative.app.enums.IngressClientCertificateMode.Ignore),
    Accept(com.pulumi.azurenative.app.enums.IngressClientCertificateMode.Accept),
    Require(com.pulumi.azurenative.app.enums.IngressClientCertificateMode.Require),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.IngressClientCertificateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.IngressClientCertificateMode):
            IngressClientCertificateMode =
            IngressClientCertificateMode.values().first { it.javaValue == javaType }
    }
}
