@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
 */
public enum class LogLevel(
    public val javaValue: com.pulumi.azurenative.app.enums.LogLevel,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.LogLevel> {
    Info(com.pulumi.azurenative.app.enums.LogLevel.Info),
    Debug(com.pulumi.azurenative.app.enums.LogLevel.Debug),
    Warn(com.pulumi.azurenative.app.enums.LogLevel.Warn),
    Error(com.pulumi.azurenative.app.enums.LogLevel.Error),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.LogLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.LogLevel): LogLevel =
            LogLevel.values().first { it.javaValue == javaType }
    }
}
