@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AllowedAudiencesValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Allowed Audiences validation flow.
 * @property allowedAudiences The configuration settings of the allowed list of audiences from which to validate the JWT token.
 */
public data class AllowedAudiencesValidationArgs(
    public val allowedAudiences: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AllowedAudiencesValidationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AllowedAudiencesValidationArgs =
        com.pulumi.azurenative.app.inputs.AllowedAudiencesValidationArgs.builder()
            .allowedAudiences(allowedAudiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AllowedAudiencesValidationArgs].
 */
@PulumiTagMarker
public class AllowedAudiencesValidationArgsBuilder internal constructor() {
    private var allowedAudiences: Output<List<String>>? = null

    /**
     * @param value The configuration settings of the allowed list of audiences from which to validate the JWT token.
     */
    @JvmName("snlaoewnsscpmmve")
    public suspend fun allowedAudiences(`value`: Output<List<String>>) {
        this.allowedAudiences = value
    }

    @JvmName("ogieappfffegixsa")
    public suspend fun allowedAudiences(vararg values: Output<String>) {
        this.allowedAudiences = Output.all(values.asList())
    }

    /**
     * @param values The configuration settings of the allowed list of audiences from which to validate the JWT token.
     */
    @JvmName("kxsoohqnflajyqec")
    public suspend fun allowedAudiences(values: List<Output<String>>) {
        this.allowedAudiences = Output.all(values)
    }

    /**
     * @param value The configuration settings of the allowed list of audiences from which to validate the JWT token.
     */
    @JvmName("xuhhkauqqpdqgcgh")
    public suspend fun allowedAudiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param values The configuration settings of the allowed list of audiences from which to validate the JWT token.
     */
    @JvmName("dbrhwmyqkkvjdtrc")
    public suspend fun allowedAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    internal fun build(): AllowedAudiencesValidationArgs = AllowedAudiencesValidationArgs(
        allowedAudiences = allowedAudiences,
    )
}
