@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AppleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Apple provider.
 * @property enabled <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the Apple registration.
 */
public data class AppleArgs(
    public val enabled: Output<Boolean>? = null,
    public val login: Output<LoginScopesArgs>? = null,
    public val registration: Output<AppleRegistrationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AppleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AppleArgs =
        com.pulumi.azurenative.app.inputs.AppleArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AppleArgs].
 */
@PulumiTagMarker
public class AppleArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var login: Output<LoginScopesArgs>? = null

    private var registration: Output<AppleRegistrationArgs>? = null

    /**
     * @param value <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("ioicbdnecqvyiyrg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("mpqcflukhiicooif")
    public suspend fun login(`value`: Output<LoginScopesArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the Apple registration.
     */
    @JvmName("biptwlolhfhiddmk")
    public suspend fun registration(`value`: Output<AppleRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("eiuuaielcuwwbjas")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the login flow.
     */
    @JvmName("pyitytojyltugpae")
    public suspend fun login(`value`: LoginScopesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow.
     */
    @JvmName("syomkauciruixfhj")
    public suspend fun login(argument: suspend LoginScopesArgsBuilder.() -> Unit) {
        val toBeMapped = LoginScopesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the Apple registration.
     */
    @JvmName("swmgptmurqlxpums")
    public suspend fun registration(`value`: AppleRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the Apple registration.
     */
    @JvmName("gnfemcxuxqfvgqva")
    public suspend fun registration(argument: suspend AppleRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = AppleRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    internal fun build(): AppleArgs = AppleArgs(
        enabled = enabled,
        login = login,
        registration = registration,
    )
}
