@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AuthPlatformArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
 * @property enabled <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
 * @property runtimeVersion The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
 */
public data class AuthPlatformArgs(
    public val enabled: Output<Boolean>? = null,
    public val runtimeVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AuthPlatformArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AuthPlatformArgs =
        com.pulumi.azurenative.app.inputs.AuthPlatformArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthPlatformArgs].
 */
@PulumiTagMarker
public class AuthPlatformArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var runtimeVersion: Output<String>? = null

    /**
     * @param value <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    @JvmName("pflhvagefjuwhnbu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    @JvmName("yxpokubekvtdlwga")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    @JvmName("hifdnngkhggkgskd")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    @JvmName("qyeysfnnyxuksgpe")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    internal fun build(): AuthPlatformArgs = AuthPlatformArgs(
        enabled = enabled,
        runtimeVersion = runtimeVersion,
    )
}
