@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.AzureActiveDirectoryLoginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active Directory login flow.
 * @property disableWWWAuthenticate <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
 * @property loginParameters Login parameters to send to the OpenID Connect authorization endpoint when
 * a user logs in. Each parameter must be in the form "key=value".
 */
public data class AzureActiveDirectoryLoginArgs(
    public val disableWWWAuthenticate: Output<Boolean>? = null,
    public val loginParameters: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.AzureActiveDirectoryLoginArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.AzureActiveDirectoryLoginArgs =
        com.pulumi.azurenative.app.inputs.AzureActiveDirectoryLoginArgs.builder()
            .disableWWWAuthenticate(disableWWWAuthenticate?.applyValue({ args0 -> args0 }))
            .loginParameters(loginParameters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureActiveDirectoryLoginArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryLoginArgsBuilder internal constructor() {
    private var disableWWWAuthenticate: Output<Boolean>? = null

    private var loginParameters: Output<List<String>>? = null

    /**
     * @param value <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
     */
    @JvmName("gkvrahsawvwatdwm")
    public suspend fun disableWWWAuthenticate(`value`: Output<Boolean>) {
        this.disableWWWAuthenticate = value
    }

    /**
     * @param value Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("hnwjcorvodwxhrwa")
    public suspend fun loginParameters(`value`: Output<List<String>>) {
        this.loginParameters = value
    }

    @JvmName("njyqifcrudxmooqj")
    public suspend fun loginParameters(vararg values: Output<String>) {
        this.loginParameters = Output.all(values.asList())
    }

    /**
     * @param values Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("nyrwvduarocvfxsa")
    public suspend fun loginParameters(values: List<Output<String>>) {
        this.loginParameters = Output.all(values)
    }

    /**
     * @param value <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
     */
    @JvmName("kcgimyeylfwcxyqt")
    public suspend fun disableWWWAuthenticate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableWWWAuthenticate = mapped
    }

    /**
     * @param value Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("odbugxipgekivtdj")
    public suspend fun loginParameters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginParameters = mapped
    }

    /**
     * @param values Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    @JvmName("vbpilewufcmgfkoi")
    public suspend fun loginParameters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginParameters = mapped
    }

    internal fun build(): AzureActiveDirectoryLoginArgs = AzureActiveDirectoryLoginArgs(
        disableWWWAuthenticate = disableWWWAuthenticate,
        loginParameters = loginParameters,
    )
}
