@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CertificatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Certificate resource specific properties
 * @property password Certificate password.
 * @property value PFX or PEM blob
 */
public data class CertificatePropertiesArgs(
    public val password: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CertificatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CertificatePropertiesArgs =
        com.pulumi.azurenative.app.inputs.CertificatePropertiesArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificatePropertiesArgs].
 */
@PulumiTagMarker
public class CertificatePropertiesArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Certificate password.
     */
    @JvmName("ucjaiaaqlsnpxxjl")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value PFX or PEM blob
     */
    @JvmName("fdwahtwyiiamyqvp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Certificate password.
     */
    @JvmName("ucbpwqvugvttahln")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value PFX or PEM blob
     */
    @JvmName("wjdbjnaerimfxnug")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CertificatePropertiesArgs = CertificatePropertiesArgs(
        password = password,
        `value` = `value`,
    )
}
