@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ConfigurationArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.ActiveRevisionsMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Non versioned Container App configuration properties that define the mutable settings of a Container app
 * @property activeRevisionsMode ActiveRevisionsMode controls how active revisions are handled for the Container app:
 * <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
 * @property dapr Dapr configuration for the Container App.
 * @property ingress Ingress configurations.
 * @property maxInactiveRevisions Optional. Max inactive revisions a Container App can have.
 * @property registries Collection of private container registry credentials for containers used by the Container app
 * @property secrets Collection of secrets used by a Container app
 */
public data class ConfigurationArgs(
    public val activeRevisionsMode: Output<Either<String, ActiveRevisionsMode>>? = null,
    public val dapr: Output<DaprArgs>? = null,
    public val ingress: Output<IngressArgs>? = null,
    public val maxInactiveRevisions: Output<Int>? = null,
    public val registries: Output<List<RegistryCredentialsArgs>>? = null,
    public val secrets: Output<List<SecretArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ConfigurationArgs =
        com.pulumi.azurenative.app.inputs.ConfigurationArgs.builder()
            .activeRevisionsMode(
                activeRevisionsMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dapr(dapr?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ingress(ingress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxInactiveRevisions(maxInactiveRevisions?.applyValue({ args0 -> args0 }))
            .registries(
                registries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationArgs].
 */
@PulumiTagMarker
public class ConfigurationArgsBuilder internal constructor() {
    private var activeRevisionsMode: Output<Either<String, ActiveRevisionsMode>>? = null

    private var dapr: Output<DaprArgs>? = null

    private var ingress: Output<IngressArgs>? = null

    private var maxInactiveRevisions: Output<Int>? = null

    private var registries: Output<List<RegistryCredentialsArgs>>? = null

    private var secrets: Output<List<SecretArgs>>? = null

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
     */
    @JvmName("nykmsccaqhesitho")
    public suspend fun activeRevisionsMode(`value`: Output<Either<String, ActiveRevisionsMode>>) {
        this.activeRevisionsMode = value
    }

    /**
     * @param value Dapr configuration for the Container App.
     */
    @JvmName("djufqoryannkftxg")
    public suspend fun dapr(`value`: Output<DaprArgs>) {
        this.dapr = value
    }

    /**
     * @param value Ingress configurations.
     */
    @JvmName("kietmwnrfynsgmsr")
    public suspend fun ingress(`value`: Output<IngressArgs>) {
        this.ingress = value
    }

    /**
     * @param value Optional. Max inactive revisions a Container App can have.
     */
    @JvmName("hfpebrdletpfblkb")
    public suspend fun maxInactiveRevisions(`value`: Output<Int>) {
        this.maxInactiveRevisions = value
    }

    /**
     * @param value Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("jewnohlogadujjoh")
    public suspend fun registries(`value`: Output<List<RegistryCredentialsArgs>>) {
        this.registries = value
    }

    @JvmName("fdafimngcjjmlrog")
    public suspend fun registries(vararg values: Output<RegistryCredentialsArgs>) {
        this.registries = Output.all(values.asList())
    }

    /**
     * @param values Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("nsccjveghqdbhnax")
    public suspend fun registries(values: List<Output<RegistryCredentialsArgs>>) {
        this.registries = Output.all(values)
    }

    /**
     * @param value Collection of secrets used by a Container app
     */
    @JvmName("lljjlexhbtnkqhoy")
    public suspend fun secrets(`value`: Output<List<SecretArgs>>) {
        this.secrets = value
    }

    @JvmName("kbslufvysmypnmuu")
    public suspend fun secrets(vararg values: Output<SecretArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Collection of secrets used by a Container app
     */
    @JvmName("wafiatulwlmepdmi")
    public suspend fun secrets(values: List<Output<SecretArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
     */
    @JvmName("uyqwxydtgvelgtnj")
    public suspend fun activeRevisionsMode(`value`: Either<String, ActiveRevisionsMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeRevisionsMode = mapped
    }

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
     */
    @JvmName("twfdhpjtfdrocfin")
    public fun activeRevisionsMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActiveRevisionsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeRevisionsMode = mapped
    }

    /**
     * @param value ActiveRevisionsMode controls how active revisions are handled for the Container app:
     * <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
     */
    @JvmName("rieqkdamifrvtbel")
    public fun activeRevisionsMode(`value`: ActiveRevisionsMode) {
        val toBeMapped = Either.ofRight<String, ActiveRevisionsMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeRevisionsMode = mapped
    }

    /**
     * @param value Dapr configuration for the Container App.
     */
    @JvmName("lmgyklsttpheuthp")
    public suspend fun dapr(`value`: DaprArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dapr = mapped
    }

    /**
     * @param argument Dapr configuration for the Container App.
     */
    @JvmName("rygdjskknahlgkbc")
    public suspend fun dapr(argument: suspend DaprArgsBuilder.() -> Unit) {
        val toBeMapped = DaprArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dapr = mapped
    }

    /**
     * @param value Ingress configurations.
     */
    @JvmName("aafkgmrxkfkycuoh")
    public suspend fun ingress(`value`: IngressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param argument Ingress configurations.
     */
    @JvmName("jsrvtheggmxuqpxl")
    public suspend fun ingress(argument: suspend IngressArgsBuilder.() -> Unit) {
        val toBeMapped = IngressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param value Optional. Max inactive revisions a Container App can have.
     */
    @JvmName("beajkomoqkpjwstx")
    public suspend fun maxInactiveRevisions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxInactiveRevisions = mapped
    }

    /**
     * @param value Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("ociodhawnvrlaqah")
    public suspend fun registries(`value`: List<RegistryCredentialsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("wpchjasdyavwspqk")
    public suspend fun registries(argument: List<suspend RegistryCredentialsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryCredentialsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("mavreqceoedpwhkw")
    public suspend fun registries(
        vararg
        argument: suspend RegistryCredentialsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryCredentialsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param argument Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("wpnkfnjjhmjjvjuj")
    public suspend fun registries(argument: suspend RegistryCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RegistryCredentialsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.registries = mapped
    }

    /**
     * @param values Collection of private container registry credentials for containers used by the Container app
     */
    @JvmName("hnvnpmvycyyrdqrc")
    public suspend fun registries(vararg values: RegistryCredentialsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registries = mapped
    }

    /**
     * @param value Collection of secrets used by a Container app
     */
    @JvmName("ssbasorumvutpcno")
    public suspend fun secrets(`value`: List<SecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container app
     */
    @JvmName("kwiqlcvwswfrgqsu")
    public suspend fun secrets(argument: List<suspend SecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container app
     */
    @JvmName("hljuerqulrcibumv")
    public suspend fun secrets(vararg argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of secrets used by a Container app
     */
    @JvmName("vwrwcbicrnisyfxs")
    public suspend fun secrets(argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Collection of secrets used by a Container app
     */
    @JvmName("glyctruumcyltpvw")
    public suspend fun secrets(vararg values: SecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    internal fun build(): ConfigurationArgs = ConfigurationArgs(
        activeRevisionsMode = activeRevisionsMode,
        dapr = dapr,
        ingress = ingress,
        maxInactiveRevisions = maxInactiveRevisions,
        registries = registries,
        secrets = secrets,
    )
}
