@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerAppProbeTcpSocketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
 * @property host Optional: Host name to connect to, defaults to the pod IP.
 * @property port Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 */
public data class ContainerAppProbeTcpSocketArgs(
    public val host: Output<String>? = null,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerAppProbeTcpSocketArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerAppProbeTcpSocketArgs =
        com.pulumi.azurenative.app.inputs.ContainerAppProbeTcpSocketArgs.builder()
            .host(host?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerAppProbeTcpSocketArgs].
 */
@PulumiTagMarker
public class ContainerAppProbeTcpSocketArgsBuilder internal constructor() {
    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Optional: Host name to connect to, defaults to the pod IP.
     */
    @JvmName("hyodkrbdqefvtqds")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     */
    @JvmName("emxyqloktrqyvffk")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Optional: Host name to connect to, defaults to the pod IP.
     */
    @JvmName("jqrsxlaqxpugfkek")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     */
    @JvmName("cgpwbeecfevjjtgk")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ContainerAppProbeTcpSocketArgs = ContainerAppProbeTcpSocketArgs(
        host = host,
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
