@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CustomDomainConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration properties for apps environment custom domain
 * @property certificatePassword Certificate password
 * @property certificateValue PFX or PEM blob
 * @property dnsSuffix Dns suffix for the environment domain
 */
public data class CustomDomainConfigurationArgs(
    public val certificatePassword: Output<String>? = null,
    public val certificateValue: Output<String>? = null,
    public val dnsSuffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CustomDomainConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CustomDomainConfigurationArgs =
        com.pulumi.azurenative.app.inputs.CustomDomainConfigurationArgs.builder()
            .certificatePassword(certificatePassword?.applyValue({ args0 -> args0 }))
            .certificateValue(certificateValue?.applyValue({ args0 -> args0 }))
            .dnsSuffix(dnsSuffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainConfigurationArgs].
 */
@PulumiTagMarker
public class CustomDomainConfigurationArgsBuilder internal constructor() {
    private var certificatePassword: Output<String>? = null

    private var certificateValue: Output<String>? = null

    private var dnsSuffix: Output<String>? = null

    /**
     * @param value Certificate password
     */
    @JvmName("jflbkbfcvdwpndxs")
    public suspend fun certificatePassword(`value`: Output<String>) {
        this.certificatePassword = value
    }

    /**
     * @param value PFX or PEM blob
     */
    @JvmName("vbwttgnjdxwgvbah")
    public suspend fun certificateValue(`value`: Output<String>) {
        this.certificateValue = value
    }

    /**
     * @param value Dns suffix for the environment domain
     */
    @JvmName("jixrmbmaxvsrpvvp")
    public suspend fun dnsSuffix(`value`: Output<String>) {
        this.dnsSuffix = value
    }

    /**
     * @param value Certificate password
     */
    @JvmName("rupqbrtyuryjixel")
    public suspend fun certificatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificatePassword = mapped
    }

    /**
     * @param value PFX or PEM blob
     */
    @JvmName("lesjmoxfmswqwgxr")
    public suspend fun certificateValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateValue = mapped
    }

    /**
     * @param value Dns suffix for the environment domain
     */
    @JvmName("diienpvedwnhcmoa")
    public suspend fun dnsSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSuffix = mapped
    }

    internal fun build(): CustomDomainConfigurationArgs = CustomDomainConfigurationArgs(
        certificatePassword = certificatePassword,
        certificateValue = certificateValue,
        dnsSuffix = dnsSuffix,
    )
}
