@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.AppProtocol
import com.pulumi.azurenative.app.kotlin.enums.LogLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App Dapr configuration.
 * @property appId Dapr application identifier
 * @property appPort Tells Dapr which port your application is listening on
 * @property appProtocol Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
 * @property enableApiLogging Enables API logging for the Dapr sidecar
 * @property enabled Boolean indicating if the Dapr side car is enabled
 * @property httpMaxRequestSize Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB.
 * @property httpReadBufferSize Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
 * @property logLevel Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
 */
public data class DaprArgs(
    public val appId: Output<String>? = null,
    public val appPort: Output<Int>? = null,
    public val appProtocol: Output<Either<String, AppProtocol>>? = null,
    public val enableApiLogging: Output<Boolean>? = null,
    public val enabled: Output<Boolean>? = null,
    public val httpMaxRequestSize: Output<Int>? = null,
    public val httpReadBufferSize: Output<Int>? = null,
    public val logLevel: Output<Either<String, LogLevel>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DaprArgs =
        com.pulumi.azurenative.app.inputs.DaprArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appPort(appPort?.applyValue({ args0 -> args0 }))
            .appProtocol(
                appProtocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableApiLogging(enableApiLogging?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .httpMaxRequestSize(httpMaxRequestSize?.applyValue({ args0 -> args0 }))
            .httpReadBufferSize(httpReadBufferSize?.applyValue({ args0 -> args0 }))
            .logLevel(
                logLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DaprArgs].
 */
@PulumiTagMarker
public class DaprArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appPort: Output<Int>? = null

    private var appProtocol: Output<Either<String, AppProtocol>>? = null

    private var enableApiLogging: Output<Boolean>? = null

    private var enabled: Output<Boolean>? = null

    private var httpMaxRequestSize: Output<Int>? = null

    private var httpReadBufferSize: Output<Int>? = null

    private var logLevel: Output<Either<String, LogLevel>>? = null

    /**
     * @param value Dapr application identifier
     */
    @JvmName("gkjfnhpqfvutinuw")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Tells Dapr which port your application is listening on
     */
    @JvmName("doxyhndxbbjkrtmh")
    public suspend fun appPort(`value`: Output<Int>) {
        this.appPort = value
    }

    /**
     * @param value Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
     */
    @JvmName("nasfxpnmyreopeve")
    public suspend fun appProtocol(`value`: Output<Either<String, AppProtocol>>) {
        this.appProtocol = value
    }

    /**
     * @param value Enables API logging for the Dapr sidecar
     */
    @JvmName("erbuvwnbqhwfdffo")
    public suspend fun enableApiLogging(`value`: Output<Boolean>) {
        this.enableApiLogging = value
    }

    /**
     * @param value Boolean indicating if the Dapr side car is enabled
     */
    @JvmName("ujkfbdxyxrbxvlhn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB.
     */
    @JvmName("kalinqihlqpihlwj")
    public suspend fun httpMaxRequestSize(`value`: Output<Int>) {
        this.httpMaxRequestSize = value
    }

    /**
     * @param value Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
     */
    @JvmName("fenfkcugojiyfvju")
    public suspend fun httpReadBufferSize(`value`: Output<Int>) {
        this.httpReadBufferSize = value
    }

    /**
     * @param value Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
     */
    @JvmName("siqogrxtolukxvlr")
    public suspend fun logLevel(`value`: Output<Either<String, LogLevel>>) {
        this.logLevel = value
    }

    /**
     * @param value Dapr application identifier
     */
    @JvmName("paxddkcsnqsidbbo")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Tells Dapr which port your application is listening on
     */
    @JvmName("mvcifsqxsnliyqgm")
    public suspend fun appPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appPort = mapped
    }

    /**
     * @param value Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
     */
    @JvmName("hxpgleilhernmnvn")
    public suspend fun appProtocol(`value`: Either<String, AppProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appProtocol = mapped
    }

    /**
     * @param value Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
     */
    @JvmName("sdplbubdgvutyvgq")
    public fun appProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AppProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appProtocol = mapped
    }

    /**
     * @param value Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
     */
    @JvmName("kccxnmykxyjklksj")
    public fun appProtocol(`value`: AppProtocol) {
        val toBeMapped = Either.ofRight<String, AppProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appProtocol = mapped
    }

    /**
     * @param value Enables API logging for the Dapr sidecar
     */
    @JvmName("icojkljlqnqbnksn")
    public suspend fun enableApiLogging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableApiLogging = mapped
    }

    /**
     * @param value Boolean indicating if the Dapr side car is enabled
     */
    @JvmName("nfarbssigumjfbff")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB.
     */
    @JvmName("haipxclmrmiqgdqv")
    public suspend fun httpMaxRequestSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMaxRequestSize = mapped
    }

    /**
     * @param value Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
     */
    @JvmName("pbojwomukccsqpcp")
    public suspend fun httpReadBufferSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpReadBufferSize = mapped
    }

    /**
     * @param value Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
     */
    @JvmName("oalojcltdlcblnsi")
    public suspend fun logLevel(`value`: Either<String, LogLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
     */
    @JvmName("ktutfdfjtqbxxods")
    public fun logLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
     */
    @JvmName("vfwxxdyfvwljchqr")
    public fun logLevel(`value`: LogLevel) {
        val toBeMapped = Either.ofRight<String, LogLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    internal fun build(): DaprArgs = DaprArgs(
        appId = appId,
        appPort = appPort,
        appProtocol = appProtocol,
        enableApiLogging = enableApiLogging,
        enabled = enabled,
        httpMaxRequestSize = httpMaxRequestSize,
        httpReadBufferSize = httpReadBufferSize,
        logLevel = logLevel,
    )
}
