@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprSubscriptionBulkSubscribeOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dapr PubSub Bulk Subscription Options.
 * @property enabled Enable bulk subscription
 * @property maxAwaitDurationMs Maximum duration in milliseconds to wait before a bulk message is sent to the app.
 * @property maxMessagesCount Maximum number of messages to deliver in a bulk message.
 */
public data class DaprSubscriptionBulkSubscribeOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val maxAwaitDurationMs: Output<Int>? = null,
    public val maxMessagesCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprSubscriptionBulkSubscribeOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DaprSubscriptionBulkSubscribeOptionsArgs =
        com.pulumi.azurenative.app.inputs.DaprSubscriptionBulkSubscribeOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .maxAwaitDurationMs(maxAwaitDurationMs?.applyValue({ args0 -> args0 }))
            .maxMessagesCount(maxMessagesCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprSubscriptionBulkSubscribeOptionsArgs].
 */
@PulumiTagMarker
public class DaprSubscriptionBulkSubscribeOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var maxAwaitDurationMs: Output<Int>? = null

    private var maxMessagesCount: Output<Int>? = null

    /**
     * @param value Enable bulk subscription
     */
    @JvmName("hraagwpuqmvumjdw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Maximum duration in milliseconds to wait before a bulk message is sent to the app.
     */
    @JvmName("kvaxdvhfvesmtaei")
    public suspend fun maxAwaitDurationMs(`value`: Output<Int>) {
        this.maxAwaitDurationMs = value
    }

    /**
     * @param value Maximum number of messages to deliver in a bulk message.
     */
    @JvmName("bfrlyidggggghprg")
    public suspend fun maxMessagesCount(`value`: Output<Int>) {
        this.maxMessagesCount = value
    }

    /**
     * @param value Enable bulk subscription
     */
    @JvmName("qvawwjwysrsjdidf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Maximum duration in milliseconds to wait before a bulk message is sent to the app.
     */
    @JvmName("cqdebrwpjfwvtsgo")
    public suspend fun maxAwaitDurationMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAwaitDurationMs = mapped
    }

    /**
     * @param value Maximum number of messages to deliver in a bulk message.
     */
    @JvmName("yjymuvgycelruatn")
    public suspend fun maxMessagesCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMessagesCount = mapped
    }

    internal fun build(): DaprSubscriptionBulkSubscribeOptionsArgs =
        DaprSubscriptionBulkSubscribeOptionsArgs(
            enabled = enabled,
            maxAwaitDurationMs = maxAwaitDurationMs,
            maxMessagesCount = maxMessagesCount,
        )
}
