@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DotNetComponentConfigurationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration properties for a .NET Component
 * @property propertyName The name of the property
 * @property value The value of the property
 */
public data class DotNetComponentConfigurationPropertyArgs(
    public val propertyName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DotNetComponentConfigurationPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DotNetComponentConfigurationPropertyArgs =
        com.pulumi.azurenative.app.inputs.DotNetComponentConfigurationPropertyArgs.builder()
            .propertyName(propertyName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DotNetComponentConfigurationPropertyArgs].
 */
@PulumiTagMarker
public class DotNetComponentConfigurationPropertyArgsBuilder internal constructor() {
    private var propertyName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the property
     */
    @JvmName("wwwxiauisyohmiqd")
    public suspend fun propertyName(`value`: Output<String>) {
        this.propertyName = value
    }

    /**
     * @param value The value of the property
     */
    @JvmName("dvbkaywitqcsqkvb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the property
     */
    @JvmName("stimftybeiskisun")
    public suspend fun propertyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value The value of the property
     */
    @JvmName("oilgwwnvwkrikubo")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DotNetComponentConfigurationPropertyArgs =
        DotNetComponentConfigurationPropertyArgs(
            propertyName = propertyName,
            `value` = `value`,
        )
}
