@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DotNetComponentServiceBindArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration to bind a .NET Component to another .NET Component
 * @property name Name of the service bind
 * @property serviceId Resource id of the target service
 */
public data class DotNetComponentServiceBindArgs(
    public val name: Output<String>? = null,
    public val serviceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DotNetComponentServiceBindArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DotNetComponentServiceBindArgs =
        com.pulumi.azurenative.app.inputs.DotNetComponentServiceBindArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceId(serviceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DotNetComponentServiceBindArgs].
 */
@PulumiTagMarker
public class DotNetComponentServiceBindArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var serviceId: Output<String>? = null

    /**
     * @param value Name of the service bind
     */
    @JvmName("qavwtwbnlrminsas")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource id of the target service
     */
    @JvmName("ytvbwsqdwrwcrfjt")
    public suspend fun serviceId(`value`: Output<String>) {
        this.serviceId = value
    }

    /**
     * @param value Name of the service bind
     */
    @JvmName("ifvabtavjxlvoxtk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource id of the target service
     */
    @JvmName("etdobrejgyykuabp")
    public suspend fun serviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceId = mapped
    }

    internal fun build(): DotNetComponentServiceBindArgs = DotNetComponentServiceBindArgs(
        name = name,
        serviceId = serviceId,
    )
}
