@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ForwardProxyArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.ForwardProxyConvention
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of a forward proxy used to make the requests.
 * @property convention The convention used to determine the url of the request made.
 * @property customHostHeaderName The name of the header containing the host of the request.
 * @property customProtoHeaderName The name of the header containing the scheme of the request.
 */
public data class ForwardProxyArgs(
    public val convention: Output<ForwardProxyConvention>? = null,
    public val customHostHeaderName: Output<String>? = null,
    public val customProtoHeaderName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ForwardProxyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ForwardProxyArgs =
        com.pulumi.azurenative.app.inputs.ForwardProxyArgs.builder()
            .convention(convention?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customHostHeaderName(customHostHeaderName?.applyValue({ args0 -> args0 }))
            .customProtoHeaderName(customProtoHeaderName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ForwardProxyArgs].
 */
@PulumiTagMarker
public class ForwardProxyArgsBuilder internal constructor() {
    private var convention: Output<ForwardProxyConvention>? = null

    private var customHostHeaderName: Output<String>? = null

    private var customProtoHeaderName: Output<String>? = null

    /**
     * @param value The convention used to determine the url of the request made.
     */
    @JvmName("najrioryltalsqik")
    public suspend fun convention(`value`: Output<ForwardProxyConvention>) {
        this.convention = value
    }

    /**
     * @param value The name of the header containing the host of the request.
     */
    @JvmName("lfxoveyikqqxfmwh")
    public suspend fun customHostHeaderName(`value`: Output<String>) {
        this.customHostHeaderName = value
    }

    /**
     * @param value The name of the header containing the scheme of the request.
     */
    @JvmName("uplyhjdqyftshepw")
    public suspend fun customProtoHeaderName(`value`: Output<String>) {
        this.customProtoHeaderName = value
    }

    /**
     * @param value The convention used to determine the url of the request made.
     */
    @JvmName("sqcisefhnatjbudj")
    public suspend fun convention(`value`: ForwardProxyConvention?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.convention = mapped
    }

    /**
     * @param value The name of the header containing the host of the request.
     */
    @JvmName("jlkudtuxtorsughn")
    public suspend fun customHostHeaderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHostHeaderName = mapped
    }

    /**
     * @param value The name of the header containing the scheme of the request.
     */
    @JvmName("ttlbibjqocsjqfjf")
    public suspend fun customProtoHeaderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProtoHeaderName = mapped
    }

    internal fun build(): ForwardProxyArgs = ForwardProxyArgs(
        convention = convention,
        customHostHeaderName = customHostHeaderName,
        customProtoHeaderName = customProtoHeaderName,
    )
}
